/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.rei.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.display.DisplayConsumer;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;

public record SpoutFillingDisplay(EntryIngredient input, EntryIngredient fluid, EntryIngredient output, Optional<class_2960> location) implements Display
{
    public static final class_2960 POTIONS = class_2960.method_60655((String)"create", (String)"potions");
    public static final DisplaySerializer<SpoutFillingDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().fieldOf("input").forGetter(SpoutFillingDisplay::input), (App)EntryIngredient.codec().fieldOf("fluid").forGetter(SpoutFillingDisplay::fluid), (App)EntryIngredient.codec().fieldOf("output").forGetter(SpoutFillingDisplay::output), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(SpoutFillingDisplay::location)).apply((Applicative)instance, SpoutFillingDisplay::new)), (class_9139)class_9139.method_56905((class_9139)EntryIngredient.streamCodec(), SpoutFillingDisplay::input, (class_9139)EntryIngredient.streamCodec(), SpoutFillingDisplay::fluid, (class_9139)EntryIngredient.streamCodec(), SpoutFillingDisplay::output, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), SpoutFillingDisplay::location, SpoutFillingDisplay::new));

    public SpoutFillingDisplay(class_8786<FillingRecipe> entry) {
        this(entry.comp_1932().method_29177(), (FillingRecipe)entry.comp_1933());
    }

    public SpoutFillingDisplay(class_2960 id, FillingRecipe recipe) {
        this(EntryIngredients.ofIngredient((class_1856)recipe.ingredient()), IngredientHelper.createEntryIngredient(recipe.fluidIngredient()), EntryIngredients.of((class_1799)recipe.result()), Optional.of(id));
    }

    public static void register(Stream<EntryStack<?>> itemStream, Stream<EntryStack<?>> fluidStream, DisplayConsumer registry) {
        List<com.zurrtum.create.infrastructure.fluids.FluidStack> fluids = fluidStream.map(entry -> {
            FluidStack stack = (FluidStack)entry.castValue();
            return new com.zurrtum.create.infrastructure.fluids.FluidStack(stack.getFluid(), stack.getAmount(), stack.getPatch());
        }).toList();
        itemStream.forEach(entry -> {
            class_1799 stack = (class_1799)entry.castValue();
            if (PotionFluidHandler.isPotionItem(stack)) {
                registry.add((Display)new SpoutFillingDisplay(EntryIngredients.of((class_1935)class_1802.field_8469), IngredientHelper.createEntryIngredient(PotionFluidHandler.getFluidFromPotionItem(stack)), EntryIngredients.of((class_1799)stack), Optional.of(POTIONS)));
                return;
            }
            try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_7972());){
                if (capability == null) {
                    return;
                }
                int size = capability.size();
                com.zurrtum.create.infrastructure.fluids.FluidStack existingFluid = size == 1 ? capability.getStack(0) : com.zurrtum.create.infrastructure.fluids.FluidStack.EMPTY;
                for (com.zurrtum.create.infrastructure.fluids.FluidStack fluid : fluids) {
                    class_1792 item;
                    int insert;
                    if (size == 1 && !existingFluid.isEmpty() && !com.zurrtum.create.infrastructure.fluids.FluidStack.areFluidsAndComponentsEqual(existingFluid, fluid) || (insert = capability.insert(fluid, 81000)) == 0) continue;
                    class_1799 result = capability.getContainer();
                    if (!result.method_7960() && !result.method_31574(item = stack.method_7909())) {
                        class_2960 itemName = class_7923.field_41178.method_10221((Object)item);
                        class_2960 fluidName = class_7923.field_41173.method_10221((Object)fluid.getFluid());
                        class_2960 id = class_2960.method_60655((String)"create", (String)("fill_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832()));
                        registry.add((Display)new SpoutFillingDisplay(EntryIngredients.of((class_1799)stack), EntryIngredients.of((FluidStack)FluidStack.create((class_3611)fluid.getFluid(), (long)insert, (class_9326)fluid.getComponentChanges())), EntryIngredients.of((class_1799)result), Optional.of(id)));
                    }
                    capability.extract(fluid, insert);
                }
            }
        });
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(this.input, this.fluid);
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(this.output);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.SPOUT_FILLING;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.location;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

