/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlockEntity;
import com.zurrtum.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class MechanicalPistonBlock
extends DirectionalAxisKineticBlock
implements IBE<MechanicalPistonBlockEntity>,
NeighborUpdateListeningBlock {
    public static final class_2754<PistonState> STATE = class_2754.method_11850((String)"state", PistonState.class);
    protected boolean isSticky;

    public static MechanicalPistonBlock normal(class_4970.class_2251 properties) {
        return new MechanicalPistonBlock(properties, false);
    }

    public static MechanicalPistonBlock sticky(class_4970.class_2251 properties) {
        return new MechanicalPistonBlock(properties, true);
    }

    protected MechanicalPistonBlock(class_4970.class_2251 properties, boolean sticky) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(STATE, (Comparable)((Object)PistonState.RETRACTED)));
        this.isSticky = sticky;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{STATE});
        super.method_9515(builder);
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (!player.method_7294()) {
            return class_1269.field_52423;
        }
        if (player.method_5715()) {
            return class_1269.field_52423;
        }
        if (!stack.method_31573(AllItemTags.SLIME_BALLS)) {
            if (stack.method_7960()) {
                this.withBlockEntityDo((class_1922)level, pos, be -> {
                    be.assembleNextTick = true;
                });
                return class_1269.field_5812;
            }
            return class_1269.field_52423;
        }
        if (state.method_11654(STATE) != PistonState.RETRACTED) {
            return class_1269.field_52423;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        if (hitResult.method_17780() != direction) {
            return class_1269.field_52423;
        }
        if (((MechanicalPistonBlock)state.method_26204()).isSticky) {
            return class_1269.field_52423;
        }
        if (level.field_9236) {
            class_243 vec = hitResult.method_17784();
            level.method_8406((class_2394)class_2398.field_11246, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0);
            return class_1269.field_5812;
        }
        AllSoundEvents.SLIME_ADDED.playOnServer(level, (class_2382)pos, 0.5f, 1.0f);
        if (!player.method_68878()) {
            stack.method_7934(1);
        }
        level.method_8501(pos, (class_2680)((class_2680)AllBlocks.STICKY_MECHANICAL_PISTON.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657((class_2769)AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.method_11654((class_2769)AXIS_ALONG_FIRST_COORDINATE))));
        return class_1269.field_5812;
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 fromPos, boolean isMoving) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        if (!fromPos.equals((Object)pos.method_10093(direction.method_10153()))) {
            return;
        }
        if (!world.field_9236 && !world.method_8397().method_8677(pos, (Object)this)) {
            world.method_64310(pos, (class_2248)this, 1);
        }
    }

    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 r) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2680 pole = worldIn.method_8320(pos.method_10093(direction.method_10153()));
        if (!pole.method_27852((class_2248)AllBlocks.PISTON_EXTENSION_POLE)) {
            if (pole.method_27852(class_2246.field_10124)) {
                this.withBlockEntityDo((class_1922)worldIn, pos, be -> {
                    class_2350 movementOppositeDirection;
                    if (be.running) {
                        return;
                    }
                    float speed = be.getSpeed();
                    if (speed == 0.0f) {
                        return;
                    }
                    class_2350 positive = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)direction.method_10166());
                    class_2350 class_23502 = movementOppositeDirection = speed > 0.0f ^ direction.method_10166() != class_2350.class_2351.field_11051 ? positive.method_10153() : positive;
                    if (movementOppositeDirection == direction) {
                        be.assembleNextTick = true;
                    }
                });
            }
            return;
        }
        if (((class_2350)pole.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() != direction.method_10166()) {
            return;
        }
        this.withBlockEntityDo((class_1922)worldIn, pos, be -> {
            float speed;
            if (!be.running && (speed = be.getSpeed()) != 0.0f) {
                class_2350 movementDirection;
                class_2350 positive = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)direction.method_10166());
                class_2350 class_23502 = movementDirection = speed > 0.0f ^ direction.method_10166() != class_2350.class_2351.field_11051 ? positive : positive.method_10153();
                if (movementDirection == direction) {
                    be.assembleNextTick = true;
                }
            }
            if (be.lastException == null) {
                return;
            }
            be.lastException = null;
            be.sendData();
        });
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (state.method_11654(STATE) != PistonState.RETRACTED) {
            return class_1269.field_5811;
        }
        return super.onWrenched(state, context);
    }

    public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        class_2680 block;
        class_2338 currentPos;
        int offset;
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 pistonHead = null;
        class_2338 pistonBase = pos;
        boolean dropBlocks = player == null || !player.method_68878();
        Integer maxPoles = MechanicalPistonBlock.maxAllowedPistonPoles();
        for (offset = 1; offset < maxPoles; ++offset) {
            currentPos = pos.method_10079(direction, offset);
            block = worldIn.method_8320(currentPos);
            if (MechanicalPistonBlock.isExtensionPole(block) && direction.method_10166() == ((class_2350)block.method_11654((class_2769)class_2741.field_12525)).method_10166()) continue;
            if (!MechanicalPistonBlock.isPistonHead(block) || block.method_11654((class_2769)class_2741.field_12525) != direction) break;
            pistonHead = currentPos;
            break;
        }
        if (pistonHead != null && pistonBase != null) {
            class_2338.method_20437((class_2338)pistonBase, pistonHead).filter(p -> !p.equals((Object)pos)).forEach(p -> worldIn.method_22352(p, dropBlocks));
        }
        for (offset = 1; offset < maxPoles && MechanicalPistonBlock.isExtensionPole(block = worldIn.method_8320(currentPos = pos.method_10079(direction.method_10153(), offset))) && direction.method_10166() == ((class_2350)block.method_11654((class_2769)class_2741.field_12525)).method_10166(); ++offset) {
            worldIn.method_22352(currentPos, dropBlocks);
        }
        return super.method_9576(worldIn, pos, state, player);
    }

    public static int maxAllowedPistonPoles() {
        return (Integer)AllConfigs.server().kinetics.maxPistonPoles.get();
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        if (state.method_11654(STATE) == PistonState.EXTENDED) {
            return AllShapes.MECHANICAL_PISTON_EXTENDED.get((class_2350)state.method_11654((class_2769)FACING));
        }
        if (state.method_11654(STATE) == PistonState.MOVING) {
            return AllShapes.MECHANICAL_PISTON.get((class_2350)state.method_11654((class_2769)FACING));
        }
        return class_259.method_1077();
    }

    @Override
    public Class<MechanicalPistonBlockEntity> getBlockEntityClass() {
        return MechanicalPistonBlockEntity.class;
    }

    @Override
    public class_2591<? extends MechanicalPistonBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MECHANICAL_PISTON;
    }

    public static boolean isPiston(class_2680 state) {
        return state.method_27852((class_2248)AllBlocks.MECHANICAL_PISTON) || MechanicalPistonBlock.isStickyPiston(state);
    }

    public static boolean isStickyPiston(class_2680 state) {
        return state.method_27852((class_2248)AllBlocks.STICKY_MECHANICAL_PISTON);
    }

    public static boolean isExtensionPole(class_2680 state) {
        return state.method_27852((class_2248)AllBlocks.PISTON_EXTENSION_POLE);
    }

    public static boolean isPistonHead(class_2680 state) {
        return state.method_27852((class_2248)AllBlocks.MECHANICAL_PISTON_HEAD);
    }

    public static enum PistonState implements class_3542
    {
        RETRACTED,
        MOVING,
        EXTENDED;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

