/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.tank;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.boiler.BoilerHeater;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.zurrtum.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.fluids.tank.SoundPool;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import joptsimple.internal.Strings;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class BoilerData {
    static final int SAMPLE_RATE = 5;
    public static final int waterSupplyPerLevel = 810;
    private static final float passiveEngineEfficiency = 0.125f;
    int gatheredSupply;
    float[] supplyOverTime = new float[10];
    int ticksUntilNextSample;
    int currentIndex;
    public boolean needsHeatLevelUpdate;
    public boolean passiveHeat;
    public int activeHeat;
    public float waterSupply;
    public int attachedEngines;
    public int attachedWhistles;
    public int maxHeatForSize = 0;
    public int maxHeatForWater = 0;
    public int minValue = 0;
    public int maxValue = 0;
    public boolean[] occludedDirections = new boolean[]{true, true, true, true};
    public LerpedFloat gauge = LerpedFloat.linear();
    private final SoundPool.Sound sound = (level, pos) -> {
        float volume = 3.0f / (float)Math.max(2, this.attachedEngines / 6);
        float pitch = 1.18f - level.field_9229.method_43057() * 0.25f;
        level.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_26955, class_3419.field_15245, volume, pitch, false);
        AllSoundEvents.STEAM.playAt(level, pos, volume / 16.0f, 0.8f, false);
    };
    private final EnumMap<class_2350, SoundPool> pools = new EnumMap(class_2350.class);

    public void tick(FluidTankBlockEntity controller) {
        if (!this.isActive()) {
            return;
        }
        class_1937 level = controller.method_10997();
        if (level.field_9236) {
            this.pools.values().forEach(p -> p.play(level));
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && level.field_9229.method_43057() < 0.5f) {
                this.gauge.setValueNoUpdate(current + Math.min(-(current - 1.0f) * level.field_9229.method_43057(), 0.0f));
            }
            return;
        }
        if (this.needsHeatLevelUpdate && this.updateTemperature(controller)) {
            controller.notifyUpdate();
        }
        --this.ticksUntilNextSample;
        if (this.ticksUntilNextSample > 0) {
            return;
        }
        int capacity = controller.tankInventory.getMaxAmountPerStack();
        if (capacity == 0) {
            return;
        }
        this.ticksUntilNextSample = 5;
        this.supplyOverTime[this.currentIndex] = (float)this.gatheredSupply / 5.0f;
        this.waterSupply = Math.max(this.waterSupply, this.supplyOverTime[this.currentIndex]);
        this.currentIndex = (this.currentIndex + 1) % this.supplyOverTime.length;
        this.gatheredSupply = 0;
        if (this.currentIndex == 0) {
            this.waterSupply = 0.0f;
            for (float i : this.supplyOverTime) {
                this.waterSupply = Math.max(i, this.waterSupply);
            }
        }
        if (controller instanceof CreativeFluidTankBlockEntity) {
            this.waterSupply = 16200.0f;
        }
        if (this.getActualHeat(controller.getTotalTankSize()) == 18) {
            controller.award(AllAdvancements.STEAM_ENGINE_MAXED);
        }
        controller.notifyUpdate();
    }

    public void updateOcclusion(FluidTankBlockEntity controller) {
        if (!controller.method_10997().field_9236) {
            return;
        }
        if (this.attachedEngines + this.attachedWhistles == 0) {
            return;
        }
        for (class_2350 d : Iterate.horizontalDirections) {
            class_238 aabb = new class_238(controller.method_11016()).method_989((double)((float)controller.width / 2.0f - 0.5f), 0.0, (double)((float)controller.width / 2.0f - 0.5f)).method_1011(0.625);
            aabb = aabb.method_989((double)((float)d.method_10148() * ((float)controller.width / 2.0f + 0.25f)), 0.0, (double)((float)d.method_10165() * ((float)controller.width / 2.0f + 0.25f)));
            aabb = aabb.method_1009((double)((float)Math.abs(d.method_10165()) / 2.0f), 0.25, (double)((float)Math.abs(d.method_10148()) / 2.0f));
            this.occludedDirections[d.method_10161()] = !controller.method_10997().method_18026(aabb);
        }
    }

    public void queueSoundOnSide(class_2338 pos, class_2350 side) {
        SoundPool pool = this.pools.get(side);
        if (pool == null) {
            pool = new SoundPool(4, 2, this.sound);
            this.pools.put(side, pool);
        }
        pool.queueAt(pos);
    }

    public int getTheoreticalHeatLevel() {
        return this.activeHeat;
    }

    public int getMaxHeatLevelForBoilerSize(int boilerSize) {
        return Math.min(18, boilerSize / 4);
    }

    public int getMaxHeatLevelForWaterSupply() {
        return Math.min(18, class_3532.method_15386((float)this.waterSupply) / 810);
    }

    public boolean isPassive() {
        return this.passiveHeat && this.maxHeatForSize > 0 && this.maxHeatForWater > 0;
    }

    public boolean isPassive(int boilerSize) {
        this.calcMinMaxForSize(boilerSize);
        return this.isPassive();
    }

    public float getEngineEfficiency(int boilerSize) {
        if (this.isPassive(boilerSize)) {
            return 0.125f / (float)this.attachedEngines;
        }
        if (this.activeHeat == 0) {
            return 0.0f;
        }
        int actualHeat = this.getActualHeat(boilerSize);
        return this.attachedEngines <= actualHeat ? 1.0f : (float)actualHeat / (float)this.attachedEngines;
    }

    private int getActualHeat(int boilerSize) {
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        return actualHeat;
    }

    public void calcMinMaxForSize(int boilerSize) {
        this.maxHeatForSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        this.maxHeatForWater = this.getMaxHeatLevelForWaterSupply();
        this.minValue = Math.min(this.passiveHeat ? 1 : this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        this.maxValue = Math.max(this.passiveHeat ? 1 : this.activeHeat, Math.max(this.maxHeatForWater, this.maxHeatForSize));
    }

    @NotNull
    public class_5250 getHeatLevelTextComponent() {
        int boilerLevel = Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        return this.isPassive() ? class_2561.method_43471((String)"create.boiler.passive") : (boilerLevel == 0 ? class_2561.method_43471((String)"create.boiler.idle") : (boilerLevel == 18 ? class_2561.method_43471((String)"create.boiler.max_lvl") : class_2561.method_43469((String)"create.boiler.lvl", (Object[])new Object[]{String.valueOf(boilerLevel)})));
    }

    public class_5250 getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        return this.componentHelper("size", this.maxHeatForSize, forGoggles, useBlocksAsBars, styles);
    }

    public class_5250 getWaterComponent(boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        return this.componentHelper("water", this.maxHeatForWater, forGoggles, useBlocksAsBars, styles);
    }

    public class_5250 getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        return this.componentHelper("heat", this.passiveHeat ? 1 : this.activeHeat, forGoggles, useBlocksAsBars, styles);
    }

    private class_5250 componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        class_5250 base;
        class_5250 class_52502 = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        class_124 style1 = styles.length >= 1 ? styles[0] : class_124.field_1080;
        class_124 style2 = styles.length >= 2 ? styles[1] : class_124.field_1063;
        return class_2561.method_43471((String)("create.boiler." + label)).method_27692(style1).method_10852((class_2561)class_2561.method_43471((String)("create.boiler." + label + "_dots")).method_27692(style2)).method_10852((class_2561)base);
    }

    private class_5250 blockComponent(int level) {
        return class_2561.method_43470((String)("\u2588".repeat(this.minValue) + "\u2592".repeat(level - this.minValue) + "\u2591".repeat(this.maxValue - level)));
    }

    private class_5250 barComponent(int level) {
        return class_2561.method_43473().method_10852((class_2561)this.bars(Math.max(0, this.minValue - 1), class_124.field_1077)).method_10852((class_2561)this.bars(this.minValue > 0 ? 1 : 0, class_124.field_1060)).method_10852((class_2561)this.bars(Math.max(0, level - this.minValue), class_124.field_1077)).method_10852((class_2561)this.bars(Math.max(0, this.maxValue - level), class_124.field_1079)).method_10852((class_2561)this.bars(Math.max(0, Math.min(18 - this.maxValue, (this.maxValue / 5 + 1) * 5 - this.maxValue)), class_124.field_1063));
    }

    private class_5250 bars(int level, class_124 format) {
        return class_2561.method_43470((String)Strings.repeat((char)'|', (int)level)).method_27692(format);
    }

    public boolean evaluate(FluidTankBlockEntity controller) {
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        int prevEngines = this.attachedEngines;
        int prevWhistles = this.attachedWhistles;
        this.attachedEngines = 0;
        this.attachedWhistles = 0;
        for (int yOffset = 0; yOffset < controller.height; ++yOffset) {
            for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
                for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                    class_2338 pos = controllerPos.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = level.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    for (class_2350 d : Iterate.directions) {
                        class_2338 attachedPos = pos.method_10093(d);
                        class_2680 attachedState = level.method_8320(attachedPos);
                        if (attachedState.method_27852((class_2248)AllBlocks.STEAM_ENGINE) && SteamEngineBlock.getFacing(attachedState) == d) {
                            ++this.attachedEngines;
                        }
                        if (!attachedState.method_27852((class_2248)AllBlocks.STEAM_WHISTLE) || WhistleBlock.getAttachedDirection(attachedState).method_10153() != d) continue;
                        ++this.attachedWhistles;
                    }
                }
            }
        }
        this.needsHeatLevelUpdate = true;
        return prevEngines != this.attachedEngines || prevWhistles != this.attachedWhistles;
    }

    public void checkPipeOrganAdvancement(FluidTankBlockEntity controller) {
        AdvancementBehaviour behaviour = controller.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour == null || !behaviour.isOwnerPresent()) {
            return;
        }
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        HashSet<Integer> whistlePitches = new HashSet<Integer>();
        for (int yOffset = 0; yOffset < controller.height; ++yOffset) {
            for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
                for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                    class_2338 pos = controllerPos.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = level.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    for (class_2350 d : Iterate.directions) {
                        class_2586 class_25862;
                        class_2338 attachedPos = pos.method_10093(d);
                        class_2680 attachedState = level.method_8320(attachedPos);
                        if (!attachedState.method_27852((class_2248)AllBlocks.STEAM_WHISTLE) || WhistleBlock.getAttachedDirection(attachedState).method_10153() != d || !((class_25862 = level.method_8321(attachedPos)) instanceof WhistleBlockEntity)) continue;
                        WhistleBlockEntity wbe = (WhistleBlockEntity)class_25862;
                        whistlePitches.add(wbe.getPitchId());
                    }
                }
            }
        }
        if (whistlePitches.size() >= 12) {
            controller.award(AllAdvancements.PIPE_ORGAN);
        }
    }

    public boolean updateTemperature(FluidTankBlockEntity controller) {
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        this.needsHeatLevelUpdate = false;
        boolean prevPassive = this.passiveHeat;
        int prevActive = this.activeHeat;
        this.passiveHeat = false;
        this.activeHeat = 0;
        for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
            for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                class_2680 blockState;
                class_2338 pos = controllerPos.method_10069(xOffset, -1, zOffset);
                float heat = BoilerHeater.findHeat(level, pos, blockState = level.method_8320(pos));
                if (heat == 0.0f) {
                    this.passiveHeat = true;
                    continue;
                }
                if (!(heat > 0.0f)) continue;
                this.activeHeat = (int)((float)this.activeHeat + heat);
            }
        }
        this.passiveHeat &= this.activeHeat == 0;
        return prevActive != this.activeHeat || prevPassive != this.passiveHeat;
    }

    public boolean isActive() {
        return this.attachedEngines > 0 || this.attachedWhistles > 0;
    }

    public void clear() {
        this.waterSupply = 0.0f;
        this.activeHeat = 0;
        this.passiveHeat = false;
        this.attachedEngines = 0;
        Arrays.fill(this.supplyOverTime, 0.0f);
    }

    public void write(class_11372 view) {
        view.method_71464("Supply", this.waterSupply);
        view.method_71465("ActiveHeat", this.activeHeat);
        view.method_71472("PassiveHeat", this.passiveHeat);
        view.method_71465("Engines", this.attachedEngines);
        view.method_71465("Whistles", this.attachedWhistles);
        view.method_71472("Update", this.needsHeatLevelUpdate);
    }

    public void read(class_11368 view, int boilerSize) {
        this.waterSupply = view.method_71423("Supply", 0.0f);
        this.activeHeat = view.method_71424("ActiveHeat", 0);
        this.passiveHeat = view.method_71433("PassiveHeat", false);
        this.attachedEngines = view.method_71424("Engines", 0);
        this.attachedWhistles = view.method_71424("Whistles", 0);
        this.needsHeatLevelUpdate = view.method_71433("Update", false);
        Arrays.fill(this.supplyOverTime, (float)((int)this.waterSupply));
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        float target = this.isPassive(boilerSize) ? 0.125f : (forBoilerSize == 0 ? 0.0f : (float)actualHeat / ((float)forBoilerSize * 1.0f));
        this.gauge.chase(target, 0.125, LerpedFloat.Chaser.EXP);
    }

    public BoilerFluidHandler createHandler() {
        return new BoilerFluidHandler();
    }

    public class BoilerFluidHandler
    implements FluidInventory {
        private int fill;

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public FluidStack getStack(int slot) {
            return FluidStack.EMPTY;
        }

        @Override
        public int getMaxAmountPerStack() {
            return 810000;
        }

        @Override
        public void markDirty() {
            if (this.fill > 0) {
                BoilerData.this.gatheredSupply += this.fill;
                this.fill = 0;
            }
        }

        @Override
        public boolean isValid(int slot, FluidStack stack) {
            return FluidHelper.isWater(stack.getFluid());
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            this.fill += stack.getAmount();
        }
    }
}

