/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.infrastructure.particle.RotationIndicatorParticleData;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class KineticEffectHandler {
    int overStressedTime;
    public float overStressedEffect;
    int particleSpawnCountdown;
    KineticBlockEntity kte;

    public KineticEffectHandler(KineticBlockEntity kte) {
        this.kte = kte;
    }

    public void tick() {
        class_1937 world = this.kte.method_10997();
        if (world.field_9236) {
            if (this.overStressedTime > 0 && --this.overStressedTime == 0) {
                if (this.kte.isOverStressed()) {
                    this.overStressedEffect = 1.0f;
                    this.spawnEffect((class_2394)class_2398.field_11251, 0.2f, 5);
                } else {
                    this.overStressedEffect = -1.0f;
                    this.spawnEffect((class_2394)class_2398.field_11204, 0.075f, 2);
                }
            }
            if (this.overStressedEffect != 0.0f) {
                this.overStressedEffect -= this.overStressedEffect * 0.1f;
                if (Math.abs(this.overStressedEffect) < 0.0078125f) {
                    this.overStressedEffect = 0.0f;
                }
            }
        } else if (this.particleSpawnCountdown > 0 && --this.particleSpawnCountdown == 0) {
            this.spawnRotationIndicators();
        }
    }

    public void queueRotationIndicators() {
        this.particleSpawnCountdown = 2;
    }

    public void spawnEffect(class_2394 particle, float maxMotion, int amount) {
        class_1937 world = this.kte.method_10997();
        if (world == null) {
            return;
        }
        if (!world.field_9236) {
            return;
        }
        class_5819 r = world.field_9229;
        for (int i = 0; i < amount; ++i) {
            class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, r, maxMotion);
            class_243 position = VecHelper.getCenterOf((class_2382)this.kte.method_11016());
            world.method_8406(particle, position.field_1352, position.field_1351, position.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
    }

    public void spawnRotationIndicators() {
        float speed = this.kte.getSpeed();
        if (speed == 0.0f) {
            return;
        }
        class_2680 state = this.kte.method_11010();
        class_2248 block = state.method_26204();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kb = (KineticBlock)block;
        float radius1 = kb.getParticleInitialRadius();
        float radius2 = kb.getParticleTargetRadius();
        class_2350.class_2351 axis = kb.getRotationAxis(state);
        class_2338 pos = this.kte.method_11016();
        class_1937 world = this.kte.method_10997();
        if (axis == null) {
            return;
        }
        if (world == null) {
            return;
        }
        class_243 vec = VecHelper.getCenterOf((class_2382)pos);
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
        int color = speedLevel.getColor();
        int particleSpeed = speedLevel.getParticleSpeed();
        particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, radius1, radius2, 10, axis);
            serverWorld.method_65096((class_2394)particleData, vec.field_1352, vec.field_1351, vec.field_1350, 20, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public void triggerOverStressedEffect() {
        this.overStressedTime = this.overStressedTime == 0 ? 2 : 0;
    }
}

