/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperItem;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.deployer.BeltDeployerCallbacks;
import com.zurrtum.create.content.kinetics.deployer.DeployerHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerItemHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationInput;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_10289;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class DeployerBlockEntity
extends KineticBlockEntity {
    public State state;
    public Mode mode;
    public class_1799 heldItem;
    protected DeployerPlayer player;
    public int timer;
    public float reach;
    public boolean fistBump = false;
    public List<class_1799> overflowItems = new ArrayList<class_1799>();
    protected ServerFilteringBehaviour filtering;
    protected boolean redstoneLocked = false;
    protected UUID owner;
    protected String ownerName;
    public class_1263 invHandler;
    private class_2487 deferredInventoryList;
    public LerpedFloat animatedOffset;
    public BeltProcessingBehaviour processingBehaviour;

    public DeployerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.DEPLOYER, pos, state);
        this.state = State.WAITING;
        this.mode = Mode.USE;
        this.heldItem = class_1799.field_8037;
        this.animatedOffset = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        this.discardPlayer();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new ServerFilteringBehaviour(this);
        behaviours.add(this.filtering);
        this.processingBehaviour = new BeltProcessingBehaviour(this).whenItemEnters((s, i) -> BeltDeployerCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> BeltDeployerCallbacks.whenItemHeld(s, i, this));
        behaviours.add(this.processingBehaviour);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.TRAIN_CASING, AllAdvancements.ANDESITE_CASING, AllAdvancements.BRASS_CASING, AllAdvancements.COPPER_CASING, AllAdvancements.FIST_BUMP, AllAdvancements.DEPLOYER, AllAdvancements.SELF_DEPLOYING);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initHandler();
    }

    public void initHandler() {
        if (this.invHandler != null) {
            return;
        }
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sLevel = (class_3218)class_19372;
            this.player = DeployerPlayer.create(sLevel, this.owner, this.ownerName);
            class_3222 serverPlayer = this.player.cast();
            if (this.deferredInventoryList != null) {
                try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), Create.LOGGER);){
                    class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)this.field_11863.method_30349(), (class_2487)this.deferredInventoryList);
                    serverPlayer.method_31548().method_7397(view.method_71437("Inventory", class_11343.field_60354));
                }
                this.deferredInventoryList = null;
                this.heldItem = serverPlayer.method_6047();
                this.sendData();
            }
            class_243 initialPos = VecHelper.getCenterOf((class_2382)this.field_11867.method_10093((class_2350)this.method_11010().method_11654(DirectionalKineticBlock.FACING)));
            serverPlayer.method_5814(initialPos.field_1352, initialPos.field_1351, initialPos.field_1350);
        }
        this.invHandler = this.createHandler();
    }

    protected void onExtract(class_1799 stack) {
        this.player.cast().method_6122(class_1268.field_5808, stack.method_7972());
        this.sendData();
        this.method_5431();
    }

    public int getTimerSpeed() {
        return (int)(this.getSpeed() == 0.0f ? 0.0f : class_3532.method_15363((float)Math.abs(this.getSpeed() * 2.0f), (float)8.0f, (float)512.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.field_11863.field_9236 && this.player != null && this.player.getBlockBreakingProgress() != null && this.field_11863.method_22347((class_2338)this.player.getBlockBreakingProgress().getKey())) {
            this.field_11863.method_8517(this.player.cast().method_5628(), (class_2338)this.player.getBlockBreakingProgress().getKey(), -1);
            this.player.setBlockBreakingProgress(null);
        }
        if (this.timer > 0) {
            this.timer -= this.getTimerSpeed();
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.player == null) {
            return;
        }
        class_3222 serverPlayer = this.player.cast();
        class_1799 stack = serverPlayer.method_6047();
        if (this.state == State.WAITING) {
            if (!this.overflowItems.isEmpty()) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            boolean changed = false;
            class_1661 inventory = serverPlayer.method_31548();
            int size = inventory.method_5439();
            for (int i = 0; i < size && this.overflowItems.size() <= 10; ++i) {
                class_1799 item = inventory.method_5438(i);
                if (item.method_7960() || item == stack && this.filtering.test(item)) continue;
                this.overflowItems.add(item);
                inventory.method_5447(i, class_1799.field_8037);
                changed = true;
            }
            if (changed) {
                this.sendData();
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            class_2350 facing = (class_2350)this.method_11010().method_11654(DirectionalKineticBlock.FACING);
            if (this.mode == Mode.USE && !DeployerHandler.shouldActivate(stack, this.field_11863, this.field_11867.method_10079(facing, 2), facing)) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            if (this.mode == Mode.PUNCH && !this.fistBump && this.startFistBump(facing)) {
                return;
            }
            if (this.redstoneLocked) {
                return;
            }
            this.start();
            return;
        }
        if (this.state == State.EXPANDING) {
            if (this.fistBump) {
                this.triggerFistBump();
            }
            this.activate();
            this.state = State.RETRACTING;
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.RETRACTING) {
            this.state = State.WAITING;
            this.timer = 500;
            this.sendData();
            return;
        }
    }

    protected void start() {
        this.state = State.EXPANDING;
        class_243 movementVector = this.getMovementVector();
        class_243 rayOrigin = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(movementVector.method_1021(1.5));
        class_243 rayTarget = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(movementVector.method_1021(2.5));
        class_3959 rayTraceContext = new class_3959(rayOrigin, rayTarget, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.player.cast());
        class_3965 result = this.field_11863.method_17742(rayTraceContext);
        this.reach = (float)(0.5 + Math.min(result.method_17784().method_1020(rayOrigin).method_1033(), 0.75));
        this.timer = 1000;
        this.sendData();
    }

    public boolean startFistBump(class_2350 facing) {
        int i = 0;
        KineticBlockEntity partner = null;
        for (i = 2; i < 5; ++i) {
            class_2338 otherDeployer = this.field_11867.method_10079(facing, i);
            if (!this.field_11863.method_8477(otherDeployer)) {
                return false;
            }
            class_2586 other = this.field_11863.method_8321(otherDeployer);
            if (!(other instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)other;
            partner = dpe;
            break;
        }
        if (partner == null) {
            return false;
        }
        if (((class_2350)this.field_11863.method_8320(partner.method_11016()).method_11654(DirectionalKineticBlock.FACING)).method_10153() != facing || ((DeployerBlockEntity)partner).mode != Mode.PUNCH) {
            return false;
        }
        if (partner.getSpeed() == 0.0f) {
            return false;
        }
        for (DeployerBlockEntity be : Arrays.asList(this, partner)) {
            be.fistBump = true;
            be.reach = (float)(i - 2) * 0.5f;
            be.timer = 1000;
            be.state = State.EXPANDING;
            be.sendData();
        }
        return true;
    }

    public void triggerFistBump() {
        int i = 0;
        SyncedBlockEntity deployerBlockEntity = null;
        for (i = 2; i < 5; ++i) {
            class_2338 pos = this.field_11867.method_10079((class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525), i);
            if (!this.field_11863.method_8477(pos)) {
                return;
            }
            class_2586 class_25862 = this.field_11863.method_8321(pos);
            if (!(class_25862 instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)class_25862;
            deployerBlockEntity = dpe;
            break;
        }
        if (deployerBlockEntity == null) {
            return;
        }
        if (!((DeployerBlockEntity)deployerBlockEntity).fistBump || ((DeployerBlockEntity)deployerBlockEntity).state != State.EXPANDING) {
            return;
        }
        if (((DeployerBlockEntity)deployerBlockEntity).timer > 0) {
            return;
        }
        this.fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).state = State.RETRACTING;
        ((DeployerBlockEntity)deployerBlockEntity).timer = 1000;
        deployerBlockEntity.sendData();
        this.award(AllAdvancements.FIST_BUMP);
        class_2338 soundLocation = class_2338.method_49638((class_2374)class_243.method_24953((class_2382)this.field_11867).method_1019(class_243.method_24953((class_2382)deployerBlockEntity.method_11016())).method_1021(0.5));
        this.field_11863.method_8396(null, soundLocation, class_3417.field_14914, class_3419.field_15245, 0.75f, 0.75f);
    }

    protected void activate() {
        class_243 movementVector = this.getMovementVector();
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_243 center = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_2338 clickedPos = this.field_11867.method_10079(direction, 2);
        class_3222 serverPlayer = this.player.cast();
        serverPlayer.method_36457(direction == class_2350.field_11036 ? -90.0f : (direction == class_2350.field_11033 ? 90.0f : 0.0f));
        serverPlayer.method_36456(direction.method_10144());
        if (direction == class_2350.field_11033 && BlockEntityBehaviour.get((class_1922)this.field_11863, clickedPos, TransportedItemStackHandlerBehaviour.TYPE) != null) {
            return;
        }
        DeployerHandler.activate(this.player, center, clickedPos, movementVector, this.mode);
        this.award(AllAdvancements.DEPLOYER);
        if (this.player != null) {
            int count = this.heldItem.method_7947();
            this.heldItem = serverPlayer.method_6047();
            if (count != this.heldItem.method_7947()) {
                this.method_5431();
            }
        }
    }

    protected class_243 getMovementVector() {
        class_2680 state = this.method_11010();
        if (!state.method_27852((class_2248)AllBlocks.DEPLOYER)) {
            return class_243.field_1353;
        }
        return class_243.method_24954((class_2382)((class_2350)state.method_11654(DirectionalKineticBlock.FACING)).method_62675());
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.state = view.method_71426("State", State.CODEC).orElse(State.WAITING);
        this.mode = view.method_71426("Mode", Mode.CODEC).orElse(Mode.PUNCH);
        this.timer = view.method_71424("Timer", 0);
        this.redstoneLocked = view.method_71433("Powered", false);
        this.owner = view.method_71426("Owner", class_4844.field_25122).orElse(null);
        this.ownerName = view.method_71426("OwnerName", (Codec)Codec.STRING).orElse(null);
        this.deferredInventoryList = view.method_71426("Inventory", class_2487.field_25128).orElseGet(class_2487::new);
        this.overflowItems = new ArrayList<class_1799>();
        view.method_71426("Overflow", CreateCodecs.ITEM_LIST_CODEC).ifPresent(this.overflowItems::addAll);
        view.method_71426("HeldItem", class_1799.field_49266).ifPresent(item -> {
            this.heldItem = item;
        });
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.fistBump = view.method_71433("Fistbump", false);
        this.reach = view.method_71423("Reach", 0.0f);
        view.method_71426("Particle", class_1799.field_24671).ifPresent(particleStack -> SandPaperItem.spawnParticles(VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(this.getMovementVector().method_1021((double)(this.reach + 1.0f))), particleStack, this.field_11863));
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71468("Mode", Mode.CODEC, (Object)this.mode);
        view.method_71468("State", State.CODEC, (Object)this.state);
        view.method_71465("Timer", this.timer);
        view.method_71472("Powered", this.redstoneLocked);
        if (this.owner != null) {
            view.method_71468("Owner", class_4844.field_25122, (Object)this.owner);
            view.method_71468("OwnerName", (Codec)Codec.STRING, (Object)this.ownerName);
        }
        if (this.player != null) {
            class_3222 serverPlayer = this.player.cast();
            try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), Create.LOGGER);){
                class_11362 writeView = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)this.field_11863.method_30349());
                serverPlayer.method_31548().method_7384(writeView.method_71467("Inventory", class_11343.field_60354));
                view.method_71468("Inventory", class_2487.field_25128, (Object)writeView.method_71475());
            }
            class_1799 stack = serverPlayer.method_6047();
            view.method_71468("HeldItem", class_1799.field_49266, (Object)stack);
            view.method_71468("Overflow", CreateCodecs.ITEM_LIST_CODEC, this.overflowItems);
        } else if (this.deferredInventoryList != null) {
            view.method_71468("Inventory", class_2487.field_25128, (Object)this.deferredInventoryList);
        }
        super.write(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        view.method_71472("Fistbump", this.fistBump);
        view.method_71464("Reach", this.reach);
        if (this.player == null) {
            return;
        }
        if (this.player.getSpawnedItemEffects() != null) {
            class_1799 stack = this.player.getSpawnedItemEffects();
            if (!stack.method_7960()) {
                view.method_71468("Particle", class_1799.field_24671, (Object)stack);
            }
            this.player.setSpawnedItemEffects(null);
        }
    }

    @Override
    public void writeSafe(class_11372 view) {
        view.method_71468("Mode", Mode.CODEC, (Object)this.mode);
        super.writeSafe(view);
    }

    private class_1263 createHandler() {
        return new DeployerItemHandler(this);
    }

    public void redstoneUpdate() {
        if (this.field_11863.field_9236) {
            return;
        }
        boolean blockPowered = this.field_11863.method_49803(this.field_11867);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(3.0);
    }

    public void discardPlayer() {
        if (this.player == null) {
            return;
        }
        class_3222 serverPlayer = this.player.cast();
        serverPlayer.method_31548().method_7388();
        this.overflowItems.forEach(itemstack -> serverPlayer.method_7329(itemstack, true, false));
        serverPlayer.method_31472();
        this.player = null;
    }

    public void changeMode() {
        this.mode = this.mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH;
        this.method_5431();
        this.sendData();
    }

    public void setAnimatedOffset(float offset) {
        this.animatedOffset.setValue(offset);
    }

    @Nullable
    public class_1860<? extends class_9695> getRecipe(class_1799 stack) {
        if (this.player == null || this.field_11863 == null) {
            return null;
        }
        class_1799 heldItemMainhand = this.player.cast().method_6047();
        class_10289 preparedRecipes = ((class_3218)this.field_11863).method_64577().field_54638;
        if (heldItemMainhand.method_7909() instanceof SandPaperItem) {
            return preparedRecipes.method_64699(AllRecipeTypes.SANDPAPER_POLISHING, (class_9695)new class_9696(stack), this.field_11863).filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(class_8786::comp_1933).findFirst().orElse(null);
        }
        ItemApplicationInput input = new ItemApplicationInput(stack, heldItemMainhand);
        return AllRecipeTypes.DEPLOYER_RECIPES.stream().flatMap(type -> preparedRecipes.method_64699(type, (class_9695)input, this.field_11863)).filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(class_8786::comp_1933).findFirst().orElse(null);
    }

    public DeployerPlayer getPlayer() {
        return this.player;
    }

    public static enum State implements class_3542
    {
        WAITING,
        EXPANDING,
        RETRACTING,
        DUMPING;

        public static final Codec<State> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(State::values);
        }
    }

    public static enum Mode implements class_3542
    {
        PUNCH,
        USE;

        public static final Codec<Mode> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(Mode::values);
        }
    }
}

