/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.SchematicInstances;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerMovementBehaviour
extends MovementBehaviour {
    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)DeployerBlock.FACING)).method_62675()).method_1021(2.0);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.field_9236) {
            return;
        }
        this.tryGrabbingItem(context);
        DeployerPlayer player = this.getPlayer(context);
        DeployerBlockEntity.Mode mode = this.getMode(context);
        if (mode == DeployerBlockEntity.Mode.USE && !DeployerHandler.shouldActivate(player.cast().method_6047(), context.world, pos, null)) {
            return;
        }
        this.activate(context, pos, player, mode);
        this.checkForTrackPlacementAdvancement(context, player);
        this.tryDisposeOfExcess(context);
        context.stall = player.getBlockBreakingProgress() != null;
    }

    public void activate(MovementContext context, class_2338 pos, DeployerPlayer player, DeployerBlockEntity.Mode mode) {
        class_1937 world = context.world;
        player.setPlacedTracks(false);
        FilterItemStack filter = context.getFilterFromBE();
        if (filter.item().method_31574((class_1792)AllItems.SCHEMATIC)) {
            this.activateAsSchematicPrinter(context, pos, player, world, filter.item());
            return;
        }
        class_243 facingVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)DeployerBlock.FACING)).method_62675());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_243 vec = context.position.method_1020(facingVec.method_1021(2.0));
        float xRot = AbstractContraptionEntity.pitchFromVector(facingVec) - 90.0f;
        if (Math.abs(xRot) > 89.0f) {
            class_243 initial = new class_243(0.0, 0.0, 1.0);
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof OrientedContraptionEntity) {
                OrientedContraptionEntity oce = (OrientedContraptionEntity)abstractContraptionEntity;
                initial = VecHelper.rotate(initial, oce.getInitialYaw(), class_2350.class_2351.field_11052);
            }
            if ((abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
                initial = VecHelper.rotate(initial, 90.0, class_2350.class_2351.field_11052);
            }
            facingVec = (class_243)context.rotation.apply(initial);
        }
        class_3222 serverPlayer = player.cast();
        serverPlayer.method_36456(AbstractContraptionEntity.yawFromVector(facingVec));
        serverPlayer.method_36457(xRot);
        DeployerHandler.activate(player, vec, pos, facingVec, mode);
    }

    protected void checkForTrackPlacementAdvancement(MovementContext context, DeployerPlayer player) {
        if ((context.contraption instanceof MountedContraption || context.contraption instanceof CarriageContraption) && player.getPlacedTracks() && context.blockEntityData != null) {
            context.blockEntityData.method_67491("Owner", class_4844.field_25122).ifPresent(uuid -> {
                class_1657 patt0$temp = context.world.method_18470(uuid);
                if (patt0$temp instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)patt0$temp;
                    AllAdvancements.SELF_DEPLOYING.trigger(serverPlayer);
                }
            });
        }
    }

    protected void activateAsSchematicPrinter(MovementContext context, class_2338 pos, DeployerPlayer player, class_1937 world, class_1799 filter) {
        class_1799 contextStack;
        if (!filter.method_57826(AllDataComponents.SCHEMATIC_ANCHOR)) {
            return;
        }
        if (!world.method_8320(pos).method_45474()) {
            return;
        }
        if (!((Boolean)filter.method_58695(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false)).booleanValue()) {
            return;
        }
        SchematicLevel schematicWorld = SchematicInstances.get(world, filter);
        if (schematicWorld == null) {
            return;
        }
        if (!schematicWorld.getBounds().method_14662((class_2382)pos.method_10059((class_2382)schematicWorld.anchor))) {
            return;
        }
        class_2680 blockState = schematicWorld.method_8320(pos);
        ItemRequirement requirement = ItemRequirement.of(blockState, schematicWorld.method_8321(pos));
        if (requirement.isInvalid() || requirement.isEmpty()) {
            return;
        }
        if (blockState.method_27852((class_2248)AllBlocks.BELT)) {
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        class_1799 class_17992 = contextStack = requiredItems.isEmpty() ? class_1799.field_8037 : requiredItems.getFirst().stack;
        if (!context.contraption.hasUniversalCreativeCrate) {
            CombinedInvWrapper itemHandler = context.contraption.getStorage().getAllItems();
            for (ItemRequirement.StackRequirement required : requiredItems) {
                int count = required.stack.method_7947();
                int extract = itemHandler.countAll(required::matches, count);
                if (extract == count) continue;
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                contextStack = required.stack;
                itemHandler.extractAll(required::matches, contextStack.method_7947());
            }
        }
        class_2487 data = BlockHelper.prepareBlockEntityData(world, blockState, schematicWorld.method_8321(pos));
        BlockHelper.placeSchematicBlock(world, blockState, pos, contextStack, data);
        if (blockState.method_26204() instanceof class_2241 || blockState.method_26204() instanceof ITrackBlock) {
            player.setPlacedTracks(true);
        }
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.field_9236) {
            return;
        }
        if (!context.stall) {
            return;
        }
        DeployerPlayer player = this.getPlayer(context);
        DeployerBlockEntity.Mode mode = this.getMode(context);
        Pair<class_2338, Float> blockBreakingProgress = player.getBlockBreakingProgress();
        if (blockBreakingProgress != null) {
            int timer = context.data.method_68083("Timer", 0);
            if (timer < 20) {
                context.data.method_10569("Timer", ++timer);
                return;
            }
            context.data.method_10551("Timer");
            this.activate(context, (class_2338)blockBreakingProgress.getKey(), player, mode);
            this.tryDisposeOfExcess(context);
        }
        context.stall = player.getBlockBreakingProgress() != null;
    }

    @Override
    public void cancelStall(MovementContext context) {
        if (context.world.field_9236) {
            return;
        }
        super.cancelStall(context);
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        if (player.getBlockBreakingProgress() == null) {
            return;
        }
        context.world.method_8517(player.cast().method_5628(), (class_2338)player.getBlockBreakingProgress().getKey(), -1);
        player.setBlockBreakingProgress(null);
    }

    @Override
    public void stopMoving(MovementContext context) {
        if (context.world.field_9236) {
            return;
        }
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        class_3222 serverPlayer = player.cast();
        this.cancelStall(context);
        try (class_8942.class_11340 logging = new class_8942.class_11340(context.contraption.entity.method_71370(), Create.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)context.world.method_30349());
            serverPlayer.method_31548().method_7384(view.method_71467("Inventory", class_11343.field_60354));
            context.blockEntityData.method_67494("Inventory", class_2487.field_25128, (Object)view.method_71475());
        }
        serverPlayer.method_31472();
    }

    private void tryGrabbingItem(MovementContext context) {
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        class_3222 serverPlayer = player.cast();
        if (serverPlayer.method_6047().method_7960()) {
            FilterItemStack filter = context.getFilterFromBE();
            if (filter.item().method_31574((class_1792)AllItems.SCHEMATIC)) {
                return;
            }
            class_1799 held = context.contraption.getStorage().getAllItems().extract(stack -> filter.test(context.world, (class_1799)stack), 1);
            serverPlayer.method_6122(class_1268.field_5808, held);
        }
    }

    private void tryDisposeOfExcess(MovementContext context) {
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        class_1661 inv = player.cast().method_31548();
        FilterItemStack filter = context.getFilterFromBE();
        class_2371 main = inv.method_67533();
        int selected = inv.method_67532();
        for (int i = 0; i < main.size(); ++i) {
            class_1799 stack = (class_1799)main.get(i);
            if (stack.method_7960() || i == selected && filter.test(context.world, stack)) continue;
            this.dropItem(context, stack);
            main.set(i, (Object)class_1799.field_8037);
        }
        class_1661.field_56551.forEach((slot, equipmentSlot) -> {
            class_1799 stack = inv.method_5438(slot.intValue());
            if (stack.method_7960()) {
                return;
            }
            this.dropItem(context, stack);
            inv.method_5447(slot.intValue(), class_1799.field_8037);
        });
    }

    @Override
    public void writeExtraData(MovementContext context) {
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        class_1799 stack = player.cast().method_6047();
        if (stack.method_7960()) {
            return;
        }
        class_6903 ops = context.world.method_30349().method_57093((DynamicOps)class_2509.field_11560);
        context.data.method_67493("HeldItem", class_1799.field_24671, (DynamicOps)ops, (Object)stack);
    }

    private DeployerPlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof DeployerPlayer) && context.world instanceof class_3218) {
            class_5455 registryManager = context.world.method_30349();
            UUID owner = context.blockEntityData.method_67491("Owner", class_4844.field_25122).orElse(null);
            String ownerName = context.blockEntityData.method_67491("OwnerName", (Codec)Codec.STRING).orElse(null);
            DeployerPlayer player = DeployerPlayer.create((class_3218)context.world, owner, ownerName);
            player.setOnMinecartContraption(context.contraption instanceof MountedContraption);
            try (class_8942.class_11340 logging = new class_8942.class_11340(context.contraption.entity.method_71370(), Create.LOGGER);){
                class_2487 inventory = context.blockEntityData.method_67491("Inventory", class_2487.field_25128).orElseGet(class_2487::new);
                class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryManager, (class_2487)inventory);
                player.cast().method_31548().method_7397(view.method_71437("Inventory", class_11343.field_60354));
            }
            if (context.data.method_10545("HeldItem")) {
                player.cast().method_6122(class_1268.field_5808, context.data.method_67492("HeldItem", class_1799.field_24671, (DynamicOps)registryManager.method_57093((DynamicOps)class_2509.field_11560)).orElse(class_1799.field_8037));
            }
            context.blockEntityData.method_10551("Inventory");
            context.temporaryData = player;
        }
        return (DeployerPlayer)context.temporaryData;
    }

    private DeployerBlockEntity.Mode getMode(MovementContext context) {
        return context.blockEntityData.method_67491("Mode", DeployerBlockEntity.Mode.CODEC).orElse(DeployerBlockEntity.Mode.PUNCH);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }
}

