/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot.storage;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.SyncedMountedStorage;
import com.zurrtum.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import org.jetbrains.annotations.Nullable;

public class DepotMountedStorage
extends WrapperMountedItemStorage<Handler>
implements SyncedMountedStorage {
    public static final MapCodec<DepotMountedStorage> CODEC = TransportedItemStack.CODEC.optionalFieldOf("value").xmap(DepotMountedStorage::new, DepotMountedStorage::getHeld);
    private boolean dirty;

    protected DepotMountedStorage(Optional<TransportedItemStack> stack) {
        super(AllMountedStorageTypes.DEPOT);
        this.wrapped = new Handler(stack);
    }

    @Override
    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depot = (DepotBlockEntity)be;
            ((Handler)this.wrapped).getHeld().ifPresentOrElse(depot::setHeldItem, depot::removeHeldItem);
        }
    }

    @Override
    public boolean handleInteraction(class_3222 player, Contraption contraption, class_3499.class_3501 info) {
        return false;
    }

    @Override
    public void method_5431() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void afterSync(Contraption contraption, class_2338 localPos) {
        class_2586 be = contraption.presentBlockEntities.get(localPos);
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depot = (DepotBlockEntity)be;
            this.getHeld().ifPresentOrElse(depot::setHeldItem, depot::removeHeldItem);
        }
    }

    public void setHeld(TransportedItemStack stack) {
        ((Handler)this.wrapped).setHeld(Optional.of(stack));
    }

    public void removeHeldItem() {
        ((Handler)this.wrapped).setHeld(Optional.empty());
    }

    public Optional<TransportedItemStack> getHeld() {
        return ((Handler)this.wrapped).getHeld();
    }

    public static DepotMountedStorage fromDepot(DepotBlockEntity depot) {
        TransportedItemStack held = depot.getHeldItem();
        return new DepotMountedStorage(held != null ? Optional.of(held.copy()) : Optional.empty());
    }

    public class Handler
    implements ItemInventory {
        private Optional<TransportedItemStack> held;

        public Handler(Optional<TransportedItemStack> stack) {
            this.held = stack;
        }

        public int method_5439() {
            return 1;
        }

        public class_1799 method_5438(int slot) {
            if (slot > 1) {
                return class_1799.field_8037;
            }
            return this.held.map(Handler::getHeldStack).orElse(class_1799.field_8037);
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot > 1) {
                return;
            }
            this.held = stack.method_7960() ? Optional.empty() : Optional.of(new TransportedItemStack(stack));
        }

        private static class_1799 getHeldStack(TransportedItemStack held) {
            return held.stack;
        }

        public Optional<TransportedItemStack> getHeld() {
            return this.held;
        }

        public void setHeld(Optional<TransportedItemStack> stack) {
            this.held = stack;
        }

        @Override
        public void method_5431() {
            DepotMountedStorage.this.dirty = true;
        }
    }
}

