/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.ValueListDisplaySource;
import com.zurrtum.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.zurrtum.create.foundation.utility.FluidFormatter;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableInt;

public class FluidListDisplaySource
extends ValueListDisplaySource {
    @Override
    protected Stream<IntAttached<class_5250>> provideEntries(DisplayLinkContext context, int maxRows) {
        class_2586 sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof SmartObserverBlockEntity)) {
            return Stream.empty();
        }
        SmartObserverBlockEntity cobe = (SmartObserverBlockEntity)sourceBE;
        TankManipulationBehaviour tankManipulationBehaviour = cobe.getBehaviour(TankManipulationBehaviour.OBSERVE);
        ServerFilteringBehaviour filteringBehaviour = cobe.getBehaviour(ServerFilteringBehaviour.TYPE);
        FluidInventory handler = (FluidInventory)tankManipulationBehaviour.getInventory();
        if (handler == null) {
            return Stream.empty();
        }
        HashMap<class_3611, Integer> fluids = new HashMap<class_3611, Integer>();
        HashMap<class_3611, FluidStack> fluidNames = new HashMap<class_3611, FluidStack>();
        int size = handler.size();
        for (int i = 0; i < size; ++i) {
            FluidStack stack = handler.getStack(i);
            if (stack.isEmpty() || !filteringBehaviour.test(stack)) continue;
            fluids.merge(stack.getFluid(), stack.getAmount(), Integer::sum);
            fluidNames.putIfAbsent(stack.getFluid(), stack);
        }
        return fluids.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue).reversed()).limit(maxRows).map(entry -> IntAttached.with((Integer)entry.getValue(), ((FluidStack)fluidNames.get(entry.getKey())).getName().method_27661()));
    }

    @Override
    protected List<class_5250> createComponentsFromEntry(DisplayLinkContext context, IntAttached<class_5250> entry) {
        int amount = (Integer)entry.getFirst();
        class_5250 name = ((class_5250)entry.getSecond()).method_10852((class_2561)WHITESPACE);
        Couple<class_5250> formatted = FluidFormatter.asComponents(amount, this.shortenNumbers(context));
        return List.of((class_5250)formatted.getFirst(), (class_5250)formatted.getSecond(), name);
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        Integer max = ((MutableInt)context.flapDisplayContext).getValue();
        boolean shorten = this.shortenNumbers(context);
        int length = FluidFormatter.asString(max.intValue(), shorten).length();
        String layoutKey = "FluidList_" + length;
        if (layout.isLayout(layoutKey)) {
            return;
        }
        int maxCharCount = flapDisplay.getMaxCharCount(1);
        int numberLength = Math.min(maxCharCount, Math.max(3, length - 2));
        int nameLength = Math.max(maxCharCount - numberLength - 2, 0);
        FlapDisplaySection value = new FlapDisplaySection(7.0f * (float)numberLength, "number", false, false).rightAligned();
        FlapDisplaySection unit = new FlapDisplaySection(14.0f, "fluid_units", true, true);
        FlapDisplaySection name = new FlapDisplaySection(7.0f * (float)nameLength, "alphabet", false, false);
        layout.configure(layoutKey, List.of(value, unit, name));
    }

    @Override
    protected String getTranslationKey() {
        return "list_fluids";
    }

    @Override
    protected boolean valueFirst() {
        return false;
    }
}

