/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class FluidThresholdCondition
extends CargoThresholdCondition {
    public FilterItemStack compareStack = FilterItemStack.empty();

    public FluidThresholdCondition(class_2960 id) {
        super(id);
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        int foundFluid = 0;
        for (Carriage carriage : train.carriages) {
            MountedFluidStorageWrapper fluids = carriage.storage.getFluids();
            int size = fluids.size();
            for (int i = 0; i < size; ++i) {
                FluidStack fluidInTank = fluids.getStack(i);
                if (!this.compareStack.test(level, fluidInTank)) continue;
                foundFluid += fluidInTank.getAmount();
            }
        }
        this.requestStatusToUpdate(foundFluid / 1000, context);
        return operator.test(foundFluid, target * 1000);
    }

    @Override
    protected void writeAdditional(class_11372 view) {
        view.method_71468("Bucket", FilterItemStack.CODEC, (Object)this.compareStack);
    }

    @Override
    protected void readAdditional(class_11368 view) {
        super.readAdditional(view);
        view.method_71426("Bucket", FilterItemStack.CODEC).ifPresent(compareStack -> {
            this.compareStack = compareStack;
        });
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return class_2561.method_43473();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return class_2561.method_43469((String)"create.schedule.condition.threshold.status", (Object[])new Object[]{lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), class_2561.method_43471((String)"create.schedule.condition.threshold.buckets")});
    }
}

