/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.signal;

import com.google.common.base.Objects;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.signal.SignalBlock;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.content.trains.signal.SignalPropagator;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;

public class SignalBoundary
extends TrackEdgePoint {
    public Couple<Map<class_2338, Boolean>> blockEntities = Couple.create(HashMap::new);
    public Couple<SignalBlock.SignalType> types;
    public Couple<UUID> groups;
    public Couple<Boolean> sidesToUpdate;
    public Couple<SignalBlockEntity.SignalState> cachedStates;
    private final Couple<Map<UUID, Boolean>> chainedSignals = Couple.create(null, null);

    public SignalBoundary() {
        this.groups = Couple.create(null, null);
        this.sidesToUpdate = Couple.create(true, true);
        this.types = Couple.create(() -> SignalBlock.SignalType.ENTRY_SIGNAL);
        this.cachedStates = Couple.create(() -> SignalBlockEntity.SignalState.INVALID);
    }

    public void setGroup(boolean primary, UUID groupId) {
        UUID previous = this.groups.get(primary);
        this.groups.set(primary, groupId);
        UUID opposite = this.groups.get(!primary);
        Map<UUID, SignalEdgeGroup> signalEdgeGroups = Create.RAILWAYS.signalEdgeGroups;
        if (opposite != null && signalEdgeGroups.containsKey(opposite)) {
            SignalEdgeGroup oppositeGroup = signalEdgeGroups.get(opposite);
            if (previous != null) {
                oppositeGroup.removeAdjacent(previous);
            }
            if (groupId != null) {
                oppositeGroup.putAdjacent(groupId);
            }
        }
        if (groupId != null && signalEdgeGroups.containsKey(groupId)) {
            SignalEdgeGroup group = signalEdgeGroups.get(groupId);
            if (opposite != null) {
                group.putAdjacent(opposite);
            }
        }
    }

    public void setGroupAndUpdate(TrackNode side, UUID groupId) {
        boolean primary = this.isPrimary(side);
        this.setGroup(primary, groupId);
        this.sidesToUpdate.set(primary, false);
        this.chainedSignals.set(primary, null);
    }

    @Override
    public boolean canMerge() {
        return true;
    }

    @Override
    public void invalidate(class_1936 level) {
        this.blockEntities.forEach(s -> s.keySet().forEach(p -> this.invalidateAt(level, (class_2338)p)));
        MinecraftServer server = level.method_8503();
        this.groups.forEach(uuid -> {
            if (Create.RAILWAYS.signalEdgeGroups.remove(uuid) != null) {
                Create.RAILWAYS.sync.edgeGroupRemoved(server, (UUID)uuid);
            }
        });
    }

    @Override
    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return otherType == this.getType();
    }

    @Override
    public void blockEntityAdded(class_2586 blockEntity, boolean front) {
        SignalBlockEntity ste;
        Map<class_2338, Boolean> blockEntitiesOnSide = this.blockEntities.get(front);
        if (blockEntitiesOnSide.isEmpty()) {
            blockEntity.method_11010().method_28500(SignalBlock.TYPE).ifPresent(type -> this.types.set(front, (SignalBlock.SignalType)((Object)type)));
        }
        blockEntitiesOnSide.put(blockEntity.method_11016(), blockEntity instanceof SignalBlockEntity && (ste = (SignalBlockEntity)blockEntity).getReportedPower());
    }

    public void updateBlockEntityPower(SignalBlockEntity blockEntity) {
        for (boolean front : Iterate.trueAndFalse) {
            this.blockEntities.get(front).computeIfPresent(blockEntity.method_11016(), (p, c) -> blockEntity.getReportedPower());
        }
    }

    @Override
    public void blockEntityRemoved(MinecraftServer server, class_2338 blockEntityPos, boolean front) {
        this.blockEntities.forEach(s -> s.remove(blockEntityPos));
        if (this.blockEntities.both(Map::isEmpty)) {
            this.removeFromAllGraphs(server);
        }
    }

    @Override
    public void onRemoved(MinecraftServer server, TrackGraph graph) {
        super.onRemoved(server, graph);
        SignalPropagator.onSignalRemoved(server, graph, this);
    }

    public void queueUpdate(TrackNode side) {
        this.sidesToUpdate.set(this.isPrimary(side), true);
    }

    public UUID getGroup(TrackNode side) {
        return this.groups.get(this.isPrimary(side));
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return !this.blockEntities.get(this.isPrimary(side)).isEmpty();
    }

    public SignalBlockEntity.OverlayState getOverlayFor(class_2338 blockEntity) {
        for (boolean first : Iterate.trueAndFalse) {
            Map<class_2338, Boolean> set = this.blockEntities.get(first);
            Iterator<class_2338> iterator = set.keySet().iterator();
            if (!iterator.hasNext()) continue;
            class_2338 blockPos = iterator.next();
            if (blockPos.equals((Object)blockEntity)) {
                return this.blockEntities.get(!first).isEmpty() ? SignalBlockEntity.OverlayState.RENDER : SignalBlockEntity.OverlayState.DUAL;
            }
            return SignalBlockEntity.OverlayState.SKIP;
        }
        return SignalBlockEntity.OverlayState.SKIP;
    }

    public SignalBlock.SignalType getTypeFor(class_2338 blockEntity) {
        return this.types.get(((Map)this.blockEntities.getFirst()).containsKey(blockEntity));
    }

    public SignalBlockEntity.SignalState getStateFor(class_2338 blockEntity) {
        for (boolean first : Iterate.trueAndFalse) {
            Map<class_2338, Boolean> set = this.blockEntities.get(first);
            if (!set.containsKey(blockEntity)) continue;
            return this.cachedStates.get(first);
        }
        return SignalBlockEntity.SignalState.INVALID;
    }

    @Override
    public void tick(MinecraftServer server, TrackGraph graph, boolean preTrains) {
        super.tick(server, graph, preTrains);
        if (!preTrains) {
            this.tickState(server, graph);
            return;
        }
        for (boolean front : Iterate.trueAndFalse) {
            if (!this.sidesToUpdate.get(front).booleanValue()) continue;
            this.sidesToUpdate.set(front, false);
            SignalPropagator.propagateSignalGroup(server, graph, this, front);
            this.chainedSignals.set(front, null);
        }
    }

    private void tickState(MinecraftServer server, TrackGraph graph) {
        for (boolean current : Iterate.trueAndFalse) {
            Map<class_2338, Boolean> set = this.blockEntities.get(current);
            if (set.isEmpty()) continue;
            boolean forcedRed = this.isForcedRed(current);
            UUID group = this.groups.get(current);
            if (Objects.equal((Object)group, (Object)this.groups.get(!current))) {
                this.cachedStates.set(current, SignalBlockEntity.SignalState.INVALID);
                continue;
            }
            Map<UUID, SignalEdgeGroup> signalEdgeGroups = Create.RAILWAYS.signalEdgeGroups;
            SignalEdgeGroup signalEdgeGroup = signalEdgeGroups.get(group);
            if (signalEdgeGroup == null) {
                this.cachedStates.set(current, SignalBlockEntity.SignalState.INVALID);
                continue;
            }
            boolean occupiedUnlessBySelf = forcedRed || signalEdgeGroup.isOccupiedUnless(this);
            this.cachedStates.set(current, occupiedUnlessBySelf ? SignalBlockEntity.SignalState.RED : this.resolveSignalChain(server, graph, current));
        }
    }

    public boolean isForcedRed(TrackNode side) {
        return this.isForcedRed(this.isPrimary(side));
    }

    public boolean isForcedRed(boolean primary) {
        Collection<Boolean> values = this.blockEntities.get(primary).values();
        for (Boolean b : values) {
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private SignalBlockEntity.SignalState resolveSignalChain(MinecraftServer server, TrackGraph graph, boolean side) {
        if (this.types.get(side) != SignalBlock.SignalType.CROSS_SIGNAL) {
            return SignalBlockEntity.SignalState.GREEN;
        }
        if (this.chainedSignals.get(side) == null) {
            this.chainedSignals.set(side, SignalPropagator.collectChainedSignals(server, graph, this, side));
        }
        boolean allPathsFree = true;
        boolean noPathsFree = true;
        boolean invalid = false;
        for (Map.Entry<UUID, Boolean> entry : this.chainedSignals.get(side).entrySet()) {
            UUID uuid = entry.getKey();
            boolean sideOfOther = entry.getValue();
            SignalBoundary otherSignal = graph.getPoint(EdgePointType.SIGNAL, uuid);
            if (otherSignal == null) {
                invalid = true;
                break;
            }
            if (otherSignal.blockEntities.get(sideOfOther).isEmpty()) continue;
            SignalBlockEntity.SignalState otherState = otherSignal.cachedStates.get(sideOfOther);
            allPathsFree &= otherState == SignalBlockEntity.SignalState.GREEN || otherState == SignalBlockEntity.SignalState.INVALID;
            noPathsFree &= otherState == SignalBlockEntity.SignalState.RED;
        }
        if (invalid) {
            this.chainedSignals.set(side, null);
            return SignalBlockEntity.SignalState.INVALID;
        }
        if (allPathsFree) {
            return SignalBlockEntity.SignalState.GREEN;
        }
        if (noPathsFree) {
            return SignalBlockEntity.SignalState.RED;
        }
        return SignalBlockEntity.SignalState.YELLOW;
    }

    @Override
    public void read(class_11368 view, boolean migration, DimensionPalette dimensions) {
        boolean first;
        int i;
        super.read(view, migration, dimensions);
        if (migration) {
            return;
        }
        this.blockEntities = Couple.create(HashMap::new);
        this.groups = Couple.create(null, null);
        for (i = 1; i <= 2; ++i) {
            first = i == 1;
            view.method_71426("Tiles" + i, CreateCodecs.BLOCK_POS_BOOLEAN_MAP_CODEC).ifPresent(map -> this.blockEntities.set(first, (Map<class_2338, Boolean>)map));
        }
        for (i = 1; i <= 2; ++i) {
            first = i == 1;
            view.method_71426("Group" + i, class_4844.field_25122).ifPresent(uuid -> this.groups.set(first, (UUID)uuid));
        }
        for (i = 1; i <= 2; ++i) {
            this.sidesToUpdate.set(i == 1, view.method_71433("Update" + i, false));
        }
        for (i = 1; i <= 2; ++i) {
            this.types.set(i == 1, view.method_71426("Type" + i, SignalBlock.SignalType.CODEC).orElse(SignalBlock.SignalType.ENTRY_SIGNAL));
        }
        for (i = 1; i <= 2; ++i) {
            this.cachedStates.set(i == 1, view.method_71426("State" + i, SignalBlockEntity.SignalState.CODEC).orElse(SignalBlockEntity.SignalState.RED));
        }
    }

    @Override
    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        boolean first;
        int i;
        super.decode(ops, input, migration, dimensions);
        if (migration) {
            return;
        }
        this.blockEntities = Couple.create(HashMap::new);
        this.groups = Couple.create(null, null);
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        for (i = 1; i <= 2; ++i) {
            first = i == 1;
            Optional.ofNullable(map.get("Tiles" + i)).flatMap(value -> CreateCodecs.BLOCK_POS_BOOLEAN_MAP_CODEC.parse(ops, value).result()).ifPresent(value -> this.blockEntities.set(first, (Map<class_2338, Boolean>)value));
        }
        for (i = 1; i <= 2; ++i) {
            first = i == 1;
            Optional.ofNullable(map.get("Group" + i)).flatMap(value -> class_4844.field_25122.parse(ops, value).result()).ifPresent(uuid -> this.groups.set(first, (UUID)uuid));
        }
        for (i = 1; i <= 2; ++i) {
            this.sidesToUpdate.set(i == 1, Optional.ofNullable(map.get("Update" + i)).map(value -> (Boolean)ops.getBooleanValue(value).getOrThrow()).orElse(false));
        }
        for (i = 1; i <= 2; ++i) {
            this.types.set(i == 1, SignalBlock.SignalType.CODEC.parse(ops, map.get("Type" + i)).result().orElse(SignalBlock.SignalType.ENTRY_SIGNAL));
        }
        for (i = 1; i <= 2; ++i) {
            this.cachedStates.set(i == 1, SignalBlockEntity.SignalState.CODEC.parse(ops, map.get("State" + i)).result().orElse(SignalBlockEntity.SignalState.RED));
        }
    }

    @Override
    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        for (int i = 1; i <= 2; ++i) {
            if (!buffer.readBoolean()) continue;
            this.groups.set(i == 1, buffer.method_10790());
        }
    }

    @Override
    public void write(class_11372 view, DimensionPalette dimensions) {
        int i;
        super.write(view, dimensions);
        for (i = 1; i <= 2; ++i) {
            if (this.blockEntities.get(i == 1).isEmpty()) continue;
            view.method_71468("Tiles" + i, CreateCodecs.BLOCK_POS_BOOLEAN_MAP_CODEC, this.blockEntities.get(i == 1));
        }
        for (i = 1; i <= 2; ++i) {
            if (this.groups.get(i == 1) == null) continue;
            view.method_71468("Group" + i, class_4844.field_25122, (Object)this.groups.get(i == 1));
        }
        for (i = 1; i <= 2; ++i) {
            if (!this.sidesToUpdate.get(i == 1).booleanValue()) continue;
            view.method_71472("Update" + i, true);
        }
        for (i = 1; i <= 2; ++i) {
            view.method_71468("Type" + i, SignalBlock.SignalType.CODEC, (Object)this.types.get(i == 1));
        }
        for (i = 1; i <= 2; ++i) {
            view.method_71468("State" + i, SignalBlockEntity.SignalState.CODEC, (Object)this.cachedStates.get(i == 1));
        }
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        int i;
        DataResult<T> prefix = super.encode(ops, empty, dimensions);
        RecordBuilder map = ops.mapBuilder();
        for (i = 1; i <= 2; ++i) {
            if (this.blockEntities.get(i == 1).isEmpty()) continue;
            map.add("Tiles" + i, this.blockEntities.get(i == 1), CreateCodecs.BLOCK_POS_BOOLEAN_MAP_CODEC);
        }
        for (i = 1; i <= 2; ++i) {
            if (this.groups.get(i == 1) == null) continue;
            map.add("Group" + i, (Object)this.groups.get(i == 1), (Encoder)class_4844.field_25122);
        }
        for (i = 1; i <= 2; ++i) {
            if (!this.sidesToUpdate.get(i == 1).booleanValue()) continue;
            map.add("Update" + i, ops.createBoolean(true));
        }
        for (i = 1; i <= 2; ++i) {
            map.add("Type" + i, (Object)this.types.get(i == 1), SignalBlock.SignalType.CODEC);
        }
        for (i = 1; i <= 2; ++i) {
            map.add("State" + i, (Object)this.cachedStates.get(i == 1), SignalBlockEntity.SignalState.CODEC);
        }
        return map.build(prefix);
    }

    @Override
    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        for (int i = 1; i <= 2; ++i) {
            boolean hasGroup = this.groups.get(i == 1) != null;
            buffer.method_52964(hasGroup);
            if (!hasGroup) continue;
            buffer.method_10797(this.groups.get(i == 1));
        }
    }

    public void cycleSignalType(class_2338 pos) {
        this.types.set(((Map)this.blockEntities.getFirst()).containsKey(pos), SignalBlock.SignalType.values()[(this.getTypeFor(pos).ordinal() + 1) % SignalBlock.SignalType.values().length]);
    }
}

