/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.signal;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;

public abstract class TrackEdgePoint {
    public UUID id;
    public Couple<TrackNodeLocation> edgeLocation;
    public double position;
    private EdgePointType<?> type;

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public void setType(EdgePointType<?> type) {
        this.type = type;
    }

    public EdgePointType<?> getType() {
        return this.type;
    }

    public abstract boolean canMerge();

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return false;
    }

    public abstract void invalidate(class_1936 var1);

    protected void invalidateAt(class_1936 level, class_2338 blockEntityPos) {
        TrackTargetingBehaviour<?> behaviour = BlockEntityBehaviour.get((class_1922)level, blockEntityPos, TrackTargetingBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "TrackEdgePoint", Create.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)level.method_30349());
            DimensionPalette dimensions = new DimensionPalette();
            this.write((class_11372)view, dimensions);
            view.method_71468("DimensionPalette", DimensionPalette.CODEC, (Object)dimensions);
            behaviour.invalidateEdgePoint(view.method_71475());
        }
    }

    public abstract void blockEntityAdded(class_2586 var1, boolean var2);

    public abstract void blockEntityRemoved(MinecraftServer var1, class_2338 var2, boolean var3);

    public void onRemoved(MinecraftServer server, TrackGraph graph) {
    }

    public void setLocation(Couple<TrackNodeLocation> nodes, double position) {
        this.edgeLocation = nodes;
        this.position = position;
    }

    public double getLocationOn(TrackEdge edge) {
        return this.isPrimary(edge.node1) ? edge.getLength() - this.position : this.position;
    }

    public boolean canNavigateVia(TrackNode side) {
        return true;
    }

    public boolean isPrimary(TrackNode node1) {
        return ((TrackNodeLocation)((Object)this.edgeLocation.getSecond())).equals((Object)node1.getLocation());
    }

    public void read(class_11368 view, boolean migration, DimensionPalette dimensions) {
        if (migration) {
            return;
        }
        this.id = (UUID)view.method_71426("Id", class_4844.field_25122).orElseThrow();
        this.position = view.method_71422("Position", 0.0);
        Iterator edge = view.method_71438("Edge").iterator();
        this.edgeLocation = Couple.create(TrackNodeLocation.read((class_11368)edge.next(), dimensions), TrackNodeLocation.read((class_11368)edge.next(), dimensions));
    }

    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        if (migration) {
            return;
        }
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        this.id = (UUID)((Pair)class_4844.field_25122.decode(ops, map.get("Id")).getOrThrow()).getFirst();
        this.position = ops.getNumberValue(map.get("Position"), (Number)0).doubleValue();
        this.edgeLocation = Couple.create(null, null);
        ((Consumer)ops.getList(map.get("Edge")).getOrThrow()).accept(item -> {
            TrackNodeLocation location = TrackNodeLocation.decode(ops, item, dimensions);
            if (this.edgeLocation.getFirst() == null) {
                this.edgeLocation.setFirst(location);
            } else {
                this.edgeLocation.setSecond(location);
            }
        });
    }

    public void read(class_2540 buffer, DimensionPalette dimensions) {
        this.id = buffer.method_10790();
        this.edgeLocation = Couple.create(() -> TrackNodeLocation.receive(buffer, dimensions));
        this.position = buffer.readDouble();
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Id", class_4844.field_25122, (Object)this.id);
        view.method_71463("Position", this.position);
        class_11372.class_11374 edge = view.method_71476("Edge");
        ((TrackNodeLocation)((Object)this.edgeLocation.getFirst())).write(edge.method_71480(), dimensions);
        ((TrackNodeLocation)((Object)this.edgeLocation.getSecond())).write(edge.method_71480(), dimensions);
    }

    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Id", (Object)this.id, (Encoder)class_4844.field_25122);
        map.add("Position", ops.createDouble(this.position));
        ListBuilder edge = ops.listBuilder();
        edge.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)this.edgeLocation.getFirst()), ops, empty, dimensions));
        edge.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)this.edgeLocation.getSecond()), ops, empty, dimensions));
        map.add("Edge", edge.build(empty));
        return map.build(empty);
    }

    public void write(class_2540 buffer, DimensionPalette dimensions) {
        buffer.method_10812(this.type.getId());
        buffer.method_10797(this.id);
        this.edgeLocation.forEach(loc -> loc.send(buffer, dimensions));
        buffer.method_52940(this.position);
    }

    public void tick(MinecraftServer server, TrackGraph graph, boolean preTrains) {
    }

    protected void removeFromAllGraphs(MinecraftServer server) {
        for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values()) {
            if (trackGraph.removePoint(server, this.getType(), this.id) == null) continue;
            return;
        }
    }
}

