/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.advancement;

import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_179;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8779;

public class AdvancementBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<AdvancementBehaviour> TYPE = new BehaviourType();
    private UUID playerId;
    private final Set<CreateTrigger> advancements;

    public AdvancementBehaviour(SmartBlockEntity be, class_3222 player, CreateTrigger ... advancements) {
        super(be);
        this.advancements = new HashSet<CreateTrigger>(List.of(advancements));
        this.playerId = player.method_5667();
        this.removeAwarded(player);
        this.blockEntity.method_5431();
    }

    public boolean isOwnerPresent() {
        return this.playerId != null;
    }

    @Override
    public void initialize() {
        class_3222 player = this.getPlayer();
        if (player != null) {
            this.removeAwarded(player);
        }
    }

    private void removeAwarded(class_3222 player) {
        if (this.advancements.isEmpty()) {
            return;
        }
        class_2989 loader = player.method_5682().method_3851();
        class_2985 advancementTracker = player.method_14236();
        this.advancements.removeIf(trigger -> {
            Set<class_179.class_180<CreateTrigger.Conditions>> containers = trigger.listeners.get(advancementTracker);
            if (containers != null) {
                return containers.stream().allMatch(container -> advancementTracker.method_12882(container.comp_1926()).method_740());
            }
            class_8779 advancement = loader.method_12896(trigger.id);
            if (advancement == null) {
                return true;
            }
            return advancementTracker.method_12882(advancement).method_740();
        });
        if (this.advancements.isEmpty()) {
            this.playerId = null;
            this.blockEntity.method_5431();
        }
    }

    public void awardPlayerIfNear(CreateTrigger advancement, int maxDistance) {
        class_3222 player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (player.method_5707(class_243.method_24953((class_2382)this.getPos())) > (double)(maxDistance * maxDistance)) {
            return;
        }
        this.award(advancement, player);
    }

    public void awardPlayer(CreateTrigger advancement) {
        class_3222 player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.award(advancement, player);
    }

    private void award(CreateTrigger advancement, class_3222 player) {
        if (this.advancements.contains(advancement)) {
            advancement.trigger(player);
            this.removeAwarded(player);
        }
    }

    private class_3222 getPlayer() {
        if (this.playerId == null) {
            return null;
        }
        return (class_3222)this.getWorld().method_18470(this.playerId);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (this.playerId != null) {
            view.method_71468("Owner", class_4844.field_25122, (Object)this.playerId);
        }
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.playerId = view.method_71426("Owner", class_4844.field_25122).orElse(null);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static void tryAward(class_1922 reader, class_2338 pos, CreateTrigger advancement) {
        AdvancementBehaviour behaviour = BlockEntityBehaviour.get(reader, pos, TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public static void setPlacedBy(class_1937 worldIn, class_2338 pos, class_1309 placer) {
        if (worldIn.field_9236) {
            return;
        }
        class_2586 class_25862 = worldIn.method_8321(pos);
        if (!(class_25862 instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity blockEntity = (SmartBlockEntity)class_25862;
        if (placer instanceof class_3222) {
            class_3222 player = (class_3222)placer;
            if (FakePlayerHandler.has((class_1297)player)) {
                return;
            }
            blockEntity.addAdvancementBehaviour(player);
        }
    }
}

