/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.bearing.BearingContraption;
import com.zurrtum.create.content.contraptions.bearing.ClockworkContraption;
import com.zurrtum.create.content.contraptions.bearing.StabilizedContraption;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.contraptions.gantry.GantryContraption;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.contraptions.piston.PistonContraption;
import com.zurrtum.create.content.contraptions.pulley.PulleyContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;

public class AllContraptionTypes {
    public static final ContraptionType PISTON = AllContraptionTypes.register("piston", PistonContraption::new);
    public static final ContraptionType PULLEY = AllContraptionTypes.register("pulley", PulleyContraption::new);
    public static final ContraptionType MOUNTED = AllContraptionTypes.register("mounted", MountedContraption::new);
    public static final ContraptionType STABILIZED = AllContraptionTypes.register("stabilized", StabilizedContraption::new);
    public static final ContraptionType BEARING = AllContraptionTypes.register("bearing", BearingContraption::new);
    public static final ContraptionType GANTRY = AllContraptionTypes.register("gantry", GantryContraption::new);
    public static final ContraptionType CLOCKWORK = AllContraptionTypes.register("clockwork", ClockworkContraption::new);
    public static final ContraptionType CARRIAGE = AllContraptionTypes.register("carriage", CarriageContraption::new);
    public static final ContraptionType ELEVATOR = AllContraptionTypes.register("elevator", ElevatorContraption::new);

    private static ContraptionType register(String name, Supplier<? extends Contraption> factory) {
        return (ContraptionType)Registry.register(CreateRegistries.CONTRAPTION_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)name), (Object)new ContraptionType(factory));
    }

    public static void register() {
    }
}

