/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.AllDamageTypes;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class AllDamageSources {
    private static final Map<RegistryAccess, AllDamageSources> ALL = new IdentityHashMap<RegistryAccess, AllDamageSources>();
    public Registry<DamageType> registry;
    public DamageSource crush;
    public DamageSource cuckoo_surprise;
    public DamageSource fan_fire;
    public DamageSource fan_lava;
    public DamageSource drill;
    public DamageSource roller;
    public DamageSource saw;

    public static AllDamageSources get(RegistryAccess registryManager) {
        return ALL.get(registryManager);
    }

    public static AllDamageSources get(Level world) {
        return ALL.get(world.registryAccess());
    }

    public AllDamageSources(RegistryAccess registryManager) {
        this.registry = registryManager.lookupOrThrow(Registries.DAMAGE_TYPE);
        this.crush = this.create(AllDamageTypes.CRUSH);
        this.cuckoo_surprise = this.create(AllDamageTypes.CUCKOO_SURPRISE);
        this.fan_fire = this.create(AllDamageTypes.FAN_FIRE);
        this.fan_lava = this.create(AllDamageTypes.FAN_LAVA);
        this.drill = this.create(AllDamageTypes.DRILL);
        this.roller = this.create(AllDamageTypes.ROLLER);
        this.saw = this.create(AllDamageTypes.SAW);
    }

    public DamageSource create(ResourceKey<DamageType> type) {
        return new DamageSource((Holder)this.registry.getOrThrow(type));
    }

    public DamageSource potatoCannon(Entity causingEntity, Entity directEntity) {
        return new DamageSource((Holder)this.registry.getOrThrow(AllDamageTypes.POTATO_CANNON), causingEntity, directEntity);
    }

    public DamageSource runOver(Entity entity) {
        return new DamageSource((Holder)this.registry.getOrThrow(AllDamageTypes.RUN_OVER), entity);
    }

    public static void register(RegistryAccess registryManager) {
        ALL.put(registryManager, new AllDamageSources(registryManager));
    }
}

