/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.crusher.CrushingRecipe;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.HauntingRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipePropertySet;

public class AllRecipeSets {
    public static final Map<ResourceKey<RecipePropertySet>, RecipeManager.IngredientExtractor> ALL = new IdentityHashMap<ResourceKey<RecipePropertySet>, RecipeManager.IngredientExtractor>();
    public static final ResourceKey<RecipePropertySet> ITEM_APPLICATION_TARGET = AllRecipeSets.register("item_application_target");
    public static final ResourceKey<RecipePropertySet> ITEM_APPLICATION_INGREDIENT = AllRecipeSets.register("item_application_ingredient");
    public static final ResourceKey<RecipePropertySet> EMPTYING = AllRecipeSets.register("emptying");
    public static final ResourceKey<RecipePropertySet> FILLING = AllRecipeSets.register("filling");
    public static final ResourceKey<RecipePropertySet> SAND_PAPER_POLISHING = AllRecipeSets.register("sand_paper_polishing");
    public static final ResourceKey<RecipePropertySet> SPLASHING = AllRecipeSets.register("splashing");
    public static final ResourceKey<RecipePropertySet> HAUNTING = AllRecipeSets.register("haunting");
    public static final ResourceKey<RecipePropertySet> CRUSHING = AllRecipeSets.register("crushing");
    public static final ResourceKey<RecipePropertySet> MILLING = AllRecipeSets.register("milling");

    private static ResourceKey<RecipePropertySet> register(String id) {
        return ResourceKey.create((ResourceKey)RecipePropertySet.TYPE_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)id));
    }

    private static <T extends Recipe<?>> void register(ResourceKey<RecipePropertySet> key, Class<T> type, Function<T, Ingredient> getter) {
        ALL.put(key, recipe -> {
            if (type.isInstance(recipe)) {
                return Optional.of((Ingredient)getter.apply(recipe));
            }
            return Optional.empty();
        });
    }

    public static void register() {
        AllRecipeSets.register(ITEM_APPLICATION_TARGET, ManualApplicationRecipe.class, ManualApplicationRecipe::target);
        AllRecipeSets.register(ITEM_APPLICATION_INGREDIENT, ManualApplicationRecipe.class, ManualApplicationRecipe::ingredient);
        AllRecipeSets.register(EMPTYING, EmptyingRecipe.class, EmptyingRecipe::ingredient);
        AllRecipeSets.register(FILLING, FillingRecipe.class, FillingRecipe::ingredient);
        AllRecipeSets.register(SAND_PAPER_POLISHING, SandPaperPolishingRecipe.class, SandPaperPolishingRecipe::ingredient);
        AllRecipeSets.register(SPLASHING, SplashingRecipe.class, SplashingRecipe::ingredient);
        AllRecipeSets.register(HAUNTING, HauntingRecipe.class, HauntingRecipe::ingredient);
        AllRecipeSets.register(CRUSHING, CrushingRecipe.class, CrushingRecipe::ingredient);
        AllRecipeSets.register(MILLING, MillingRecipe.class, MillingRecipe::ingredient);
    }
}

