/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.components;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.world.item.ItemStack;

public class ComponentProcessors {
    public static ItemStack withUnsafeComponentsDiscarded(ItemStack stack) {
        if (stack.getComponentsPatch().isEmpty()) {
            return stack;
        }
        ItemStack copy = stack.copy();
        stack.getComponents().stream().filter(ComponentProcessors::isUnsafeItemComponent).map(TypedDataComponent::type).forEach(arg_0 -> ((ItemStack)copy).remove(arg_0));
        return copy;
    }

    public static boolean isUnsafeItemComponent(TypedDataComponent<?> component) {
        return ComponentProcessors.isUnsafeItemComponent(component.type());
    }

    public static boolean isUnsafeItemComponent(DataComponentType<?> component) {
        if (component.equals((Object)DataComponents.ENCHANTMENTS)) {
            return false;
        }
        if (component.equals((Object)DataComponents.POTION_CONTENTS)) {
            return false;
        }
        if (component.equals((Object)DataComponents.DAMAGE)) {
            return false;
        }
        return !component.equals((Object)DataComponents.CUSTOM_NAME);
    }
}

