/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SailBlock
extends WrenchableDirectionalBlock {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());
    protected final boolean frame;
    protected final DyeColor color;

    public static SailBlock frame(BlockBehaviour.Properties properties) {
        return new SailBlock(properties, true, null);
    }

    public static Function<BlockBehaviour.Properties, SailBlock> withCanvas(DyeColor color) {
        return properties -> new SailBlock((BlockBehaviour.Properties)properties, false, color);
    }

    protected SailBlock(BlockBehaviour.Properties properties, boolean frame, DyeColor color) {
        super(properties);
        this.frame = frame;
        this.color = color;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.isShiftKeyDown() && player.mayBuild() && placementHelper.matchesItem(stack)) {
            placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand);
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() instanceof ShearsItem) {
            if (!level.isClientSide()) {
                level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.applyDye(state, level, pos, hitResult.getLocation(), null);
            return InteractionResult.SUCCESS;
        }
        if (this.frame) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        DyeColor color = AllItemTags.getDyeColor(stack);
        if (color != null) {
            if (!level.isClientSide()) {
                level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.1f - level.random.nextFloat() * 0.2f);
            }
            this.applyDye(state, level, pos, hitResult.getLocation(), color);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public SailBlock getColorBlock(DyeColor color) {
        return switch (color) {
            case DyeColor.ORANGE -> AllBlocks.ORANGE_SAIL;
            case DyeColor.MAGENTA -> AllBlocks.MAGENTA_SAIL;
            case DyeColor.LIGHT_BLUE -> AllBlocks.LIGHT_BLUE_SAIL;
            case DyeColor.YELLOW -> AllBlocks.YELLOW_SAIL;
            case DyeColor.LIME -> AllBlocks.LIME_SAIL;
            case DyeColor.PINK -> AllBlocks.PINK_SAIL;
            case DyeColor.GRAY -> AllBlocks.GRAY_SAIL;
            case DyeColor.LIGHT_GRAY -> AllBlocks.LIGHT_GRAY_SAIL;
            case DyeColor.CYAN -> AllBlocks.CYAN_SAIL;
            case DyeColor.PURPLE -> AllBlocks.PURPLE_SAIL;
            case DyeColor.BLUE -> AllBlocks.BLUE_SAIL;
            case DyeColor.BROWN -> AllBlocks.BROWN_SAIL;
            case DyeColor.GREEN -> AllBlocks.GREEN_SAIL;
            case DyeColor.RED -> AllBlocks.RED_SAIL;
            case DyeColor.BLACK -> AllBlocks.BLACK_SAIL;
            default -> AllBlocks.SAIL;
        };
    }

    public void applyDye(BlockState state, Level world, BlockPos pos, Vec3 hit, @Nullable DyeColor color) {
        BlockState newState = (color == null ? AllBlocks.SAIL_FRAME : this.getColorBlock(color)).defaultBlockState();
        if (state != (newState = BlockHelper.copyProperties(state, newState))) {
            world.setBlockAndUpdate(pos, newState);
            return;
        }
        List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, ((Direction)state.getValue((Property)FACING)).getAxis());
        for (Direction d : directions) {
            BlockPos offset = pos.relative(d);
            BlockState adjacentState = world.getBlockState(offset);
            Block block = adjacentState.getBlock();
            if (!(block instanceof SailBlock) || ((SailBlock)block).frame || state.getValue((Property)FACING) != adjacentState.getValue((Property)FACING) || state == adjacentState) continue;
            world.setBlockAndUpdate(offset, newState);
            return;
        }
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        frontier.add(pos);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int timeout = 100;
        while (!frontier.isEmpty() && timeout-- >= 0) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            visited.add(currentPos);
            for (Direction d : Iterate.directions) {
                BlockState adjacentState;
                Block block;
                BlockPos offset;
                if (d.getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis() || visited.contains(offset = currentPos.relative(d)) || !((block = (adjacentState = world.getBlockState(offset)).getBlock()) instanceof SailBlock) || ((SailBlock)block).frame && color != null || adjacentState.getValue((Property)FACING) != state.getValue((Property)FACING)) continue;
                if (state != adjacentState) {
                    world.setBlockAndUpdate(offset, newState);
                }
                frontier.add(offset);
                visited.add(offset);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return (this.frame ? AllShapes.SAIL_FRAME : AllShapes.SAIL).get((Direction)state.getValue((Property)FACING));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return (this.frame ? AllShapes.SAIL_FRAME_COLLISION : AllShapes.SAIL).get((Direction)state.getValue((Property)FACING));
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack pickBlock = super.getCloneItemStack(world, pos, state, includeData);
        if (pickBlock.isEmpty()) {
            return AllBlocks.SAIL.getCloneItemStack(world, pos, state, includeData);
        }
        return pickBlock;
    }

    public void fallOn(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, double p_152430_) {
        if (this.frame) {
            super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
        }
        super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, 0.0);
    }

    public void updateEntityMovementAfterFallOn(BlockGetter p_176216_1_, Entity p_176216_2_) {
        if (this.frame || p_176216_2_.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(p_176216_1_, p_176216_2_);
        } else {
            this.bounce(p_176216_2_);
        }
    }

    private void bounce(Entity p_226860_1_) {
        Vec3 Vector3d = p_226860_1_.getDeltaMovement();
        if (Vector3d.y < 0.0) {
            double d0 = p_226860_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226860_1_.setDeltaMovement(Vector3d.x, -Vector3d.y * (double)0.26f * d0, Vector3d.z);
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public boolean isFrame() {
        return this.frame;
    }

    public DyeColor getColor() {
        return this.color;
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.is((Item)AllItems.SAIL) || stack.is((Item)AllItems.SAIL_FRAME);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return state -> state.getBlock() instanceof SailBlock;
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), ((Direction)state.getValue((Property)FACING)).getAxis(), (Direction dir) -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative(directions.get(0)), s -> (BlockState)s.setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalBlock.FACING))));
        }
    }
}

