/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class CouplingHandler {
    public static boolean preventEntitiesFromMoutingOccupiedCart(Entity entityMounting, Entity entityBeingMounted) {
        AbstractMinecart cart;
        Optional<MinecartController> value;
        if (entityBeingMounted instanceof AbstractMinecart && (value = AllSynchedDatas.MINECART_CONTROLLER.get((Entity)(cart = (AbstractMinecart)entityBeingMounted))).isPresent()) {
            return !(entityMounting instanceof AbstractContraptionEntity) && value.get().isCoupledThroughContraption();
        }
        return false;
    }

    public static void forEachLoadedCoupling(Level world, Consumer<Couple<MinecartController>> consumer) {
        if (world == null) {
            return;
        }
        Set<UUID> cartsWithCoupling = CapabilityMinecartController.loadedMinecartsWithCoupling.get((LevelAccessor)world);
        if (cartsWithCoupling == null) {
            return;
        }
        for (UUID id : cartsWithCoupling) {
            MinecartController controller = CapabilityMinecartController.getIfPresent(world, id);
            if (controller == null) {
                return;
            }
            if (!controller.isLeadingCoupling()) {
                return;
            }
            UUID coupledCart = controller.getCoupledCart(true);
            MinecartController coupledController = CapabilityMinecartController.getIfPresent(world, coupledCart);
            if (coupledController == null) {
                return;
            }
            consumer.accept(Couple.create(controller, coupledController));
        }
    }

    public static boolean tryToCoupleCarts(@Nullable Player player, Level world, int cartId1, int cartId2) {
        boolean contraptionCoupling;
        Entity entity1 = world.getEntity(cartId1);
        Entity entity2 = world.getEntity(cartId2);
        if (!(entity1 instanceof AbstractMinecart)) {
            return false;
        }
        AbstractMinecart cart1 = (AbstractMinecart)entity1;
        if (!(entity2 instanceof AbstractMinecart)) {
            return false;
        }
        AbstractMinecart cart2 = (AbstractMinecart)entity2;
        String tooMany = "two_couplings_max";
        String unloaded = "unloaded";
        String noLoops = "no_loops";
        String tooFar = "too_far";
        int distanceTo = (int)entity1.position().distanceTo(entity2.position());
        boolean bl = contraptionCoupling = player == null;
        if (distanceTo < 2) {
            if (contraptionCoupling) {
                return false;
            }
            distanceTo = 2;
        }
        if (distanceTo > (Integer)AllConfigs.server().kinetics.maxCartCouplingLength.get()) {
            CouplingHandler.status(player, tooFar);
            return false;
        }
        UUID mainID = cart1.getUUID();
        UUID connectedID = cart2.getUUID();
        MinecartController mainController = CapabilityMinecartController.getIfPresent(world, mainID);
        MinecartController connectedController = CapabilityMinecartController.getIfPresent(world, connectedID);
        if (mainController == null || connectedController == null) {
            CouplingHandler.status(player, unloaded);
            return false;
        }
        if (mainController.isFullyCoupled() || connectedController.isFullyCoupled()) {
            CouplingHandler.status(player, tooMany);
            return false;
        }
        if (mainController.isLeadingCoupling() && mainController.getCoupledCart(true).equals(connectedID) || connectedController.isLeadingCoupling() && connectedController.getCoupledCart(true).equals(mainID)) {
            return false;
        }
        block0: for (boolean main : Iterate.trueAndFalse) {
            Optional<MinecartController> next;
            MinecartController current = main ? mainController : connectedController;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            do {
                if (safetyCount-- <= 0) {
                    Create.LOGGER.warn("Infinite loop in coupling iteration");
                    return false;
                }
                next = CouplingHandler.getNextInCouplingChainLegacy(world, current, forward);
                if (next == null) {
                    CouplingHandler.status(player, unloaded);
                    return false;
                }
                if (next.isEmpty()) continue block0;
            } while ((current = next.get()) != connectedController);
            CouplingHandler.status(player, noLoops);
            return false;
        }
        if (!contraptionCoupling) {
            for (InteractionHand hand : InteractionHand.values()) {
                if (player.isCreative()) break;
                ItemStack heldItem = player.getItemInHand(hand);
                if (!heldItem.is((Item)AllItems.MINECART_COUPLING)) continue;
                heldItem.shrink(1);
                break;
            }
        }
        mainController.prepareForCoupling(true);
        connectedController.prepareForCoupling(false);
        mainController.coupleWith(true, connectedID, distanceTo, contraptionCoupling);
        connectedController.coupleWith(false, mainID, distanceTo, contraptionCoupling);
        return true;
    }

    @Nullable
    public static Optional<MinecartController> getNextInCouplingChainLegacy(Level world, MinecartController controller, boolean forward) {
        UUID coupledCart = controller.getCoupledCart(forward);
        if (coupledCart == null) {
            return Optional.empty();
        }
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(world, coupledCart);
        return coupledController == null ? null : Optional.of(coupledController);
    }

    public static Optional<MinecartController> getNextInCouplingChain(Level world, MinecartController controller, boolean forward) {
        UUID coupledCart = controller.getCoupledCart(forward);
        if (coupledCart == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(CapabilityMinecartController.getIfPresent(world, coupledCart));
    }

    public static void status(Player player, String key) {
        if (player == null) {
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)("create.minecart_coupling." + key)), true);
    }
}

