/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.pulley;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PulleyBlock
extends HorizontalAxisKineticBlock
implements IBE<PulleyBlockEntity> {
    public PulleyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static void onRopeBroken(Level world, BlockPos pulleyPos) {
        BlockEntity be = world.getBlockEntity(pulleyPos);
        if (be instanceof PulleyBlockEntity) {
            PulleyBlockEntity pulley = (PulleyBlockEntity)be;
            pulley.initialOffset = 0;
            pulley.onLengthBroken();
        }
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel worldIn, BlockPos pos, boolean isMoving) {
        super.affectNeighborsAfterRemoval(state, worldIn, pos, isMoving);
        if (worldIn.isClientSide()) {
            return;
        }
        BlockState below = worldIn.getBlockState(pos.below());
        if (below.getBlock() instanceof RopeBlockBase) {
            worldIn.destroyBlock(pos.below(), true);
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.mayBuild()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (player.isShiftKeyDown()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (stack.isEmpty()) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                be.assembleNextTick = true;
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    public Class<PulleyBlockEntity> getBlockEntityClass() {
        return PulleyBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends PulleyBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ROPE_PULLEY;
    }

    private static class RopeBlockBase
    extends Block
    implements SimpleWaterloggedBlock {
        public RopeBlockBase(BlockBehaviour.Properties properties) {
            super(properties);
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
            return false;
        }

        protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
            return AllItems.ROPE_PULLEY.getDefaultInstance();
        }

        public void affectNeighborsAfterRemoval(BlockState state, ServerLevel worldIn, BlockPos pos, boolean isMoving) {
            boolean onBroken;
            if (isMoving) {
                return;
            }
            boolean bl = onBroken = !state.hasProperty((Property)BlockStateProperties.WATERLOGGED);
            if (!onBroken) {
                BlockState newState = worldIn.getBlockState(pos);
                boolean bl2 = onBroken = !newState.hasProperty((Property)BlockStateProperties.WATERLOGGED) || state.getValue((Property)BlockStateProperties.WATERLOGGED) == newState.getValue((Property)BlockStateProperties.WATERLOGGED);
            }
            if (onBroken) {
                PulleyBlock.onRopeBroken((Level)worldIn, pos.above());
                if (!worldIn.isClientSide()) {
                    BlockState above = worldIn.getBlockState(pos.above());
                    BlockState below = worldIn.getBlockState(pos.below());
                    if (above.getBlock() instanceof RopeBlockBase) {
                        worldIn.destroyBlock(pos.above(), true);
                    }
                    if (below.getBlock() instanceof RopeBlockBase) {
                        worldIn.destroyBlock(pos.below(), true);
                    }
                }
            }
        }

        public FluidState getFluidState(BlockState state) {
            return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
            super.createBlockStateDefinition(builder);
        }

        public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighbourPos, BlockState neighbourState, RandomSource random) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
            }
            return state;
        }

        public BlockState getStateForPlacement(BlockPlaceContext context) {
            FluidState FluidState2 = context.getLevel().getFluidState(context.getClickedPos());
            return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.getType() == Fluids.WATER));
        }
    }

    public static class RopeBlock
    extends RopeBlockBase {
        public RopeBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return AllShapes.FOUR_VOXEL_POLE.get(Direction.UP);
        }
    }

    public static class MagnetBlock
    extends RopeBlockBase {
        public MagnetBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return AllShapes.PULLEY_MAGNET;
        }
    }
}

