/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.bell;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.equipment.bell.AbstractBellBlock;
import com.zurrtum.create.content.equipment.bell.HauntedBellBlock;
import com.zurrtum.create.content.equipment.bell.PeculiarBellBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PeculiarBellBlock
extends AbstractBellBlock<PeculiarBellBlockEntity> {
    public PeculiarBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntityType<? extends PeculiarBellBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.PECULIAR_BELL;
    }

    @Override
    public Class<PeculiarBellBlockEntity> getBlockEntityClass() {
        return PeculiarBellBlockEntity.class;
    }

    @Override
    public void playSound(Level world, BlockPos pos) {
        AllSoundEvents.PECULIAR_BELL_USE.playOnServer(world, (Vec3i)pos, 2.0f, 0.94f);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState newState = super.getStateForPlacement(ctx);
        if (newState == null) {
            return null;
        }
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        return this.tryConvert((LevelAccessor)world, pos, newState, world.getBlockState(pos.relative(Direction.DOWN)));
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        BlockState newState = super.updateShape(state, world, tickView, currentPos, facing, facingPos, facingState, random);
        if (facing != Direction.DOWN) {
            return newState;
        }
        return this.tryConvert((LevelAccessor)world, currentPos, newState, facingState);
    }

    protected BlockState tryConvert(LevelAccessor world, BlockPos pos, BlockState state, BlockState underState) {
        if (!state.is((Block)AllBlocks.PECULIAR_BELL)) {
            return state;
        }
        Block underBlock = underState.getBlock();
        if (!Blocks.SOUL_FIRE.equals(underBlock) && !Blocks.SOUL_CAMPFIRE.equals(underBlock)) {
            return state;
        }
        if (world.isClientSide()) {
            this.spawnConversionParticles(world, pos);
        } else if (world instanceof Level) {
            Level worldIn = (Level)world;
            AllSoundEvents.HAUNTED_BELL_CONVERT.playOnServer(worldIn, (Vec3i)pos);
        }
        return (BlockState)((BlockState)((BlockState)AllBlocks.HAUNTED_BELL.defaultBlockState().setValue((Property)HauntedBellBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)HauntedBellBlock.ATTACHMENT, (Comparable)((BellAttachType)state.getValue((Property)ATTACHMENT)))).setValue((Property)HauntedBellBlock.POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)));
    }

    public void spawnConversionParticles(LevelAccessor world, BlockPos blockPos) {
        RandomSource random = world.getRandom();
        int num = random.nextInt(10) + 15;
        for (int i = 0; i < num; ++i) {
            float pitch = random.nextFloat() * 120.0f - 90.0f;
            float yaw = random.nextFloat() * 360.0f;
            Vec3 vel = Vec3.directionFromRotation((float)pitch, (float)yaw).scale(random.nextDouble() * 0.1 + 0.1);
            Vec3 pos = Vec3.atCenterOf((Vec3i)blockPos);
            world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.x, pos.y, pos.z, vel.x, vel.y, vel.z);
        }
    }
}

