/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.symmetryWand.mirror;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlaneMirror
extends SymmetryMirror {
    public PlaneMirror(Vec3 pos) {
        super(pos);
        this.orientation = Align.XY;
    }

    @Override
    protected void setOrientation() {
        if (this.orientationIndex < 0) {
            this.orientationIndex += Align.values().length;
        }
        if (this.orientationIndex >= Align.values().length) {
            this.orientationIndex -= Align.values().length;
        }
        this.orientation = Align.values()[this.orientationIndex];
    }

    @Override
    public void setOrientation(int index) {
        this.orientation = Align.values()[index];
        this.orientationIndex = index;
    }

    @Override
    public Map<BlockPos, Pair<Direction, BlockState>> process(BlockPos position, Pair<Direction, BlockState> pair) {
        HashMap<BlockPos, Pair<Direction, BlockState>> result = new HashMap<BlockPos, Pair<Direction, BlockState>>();
        Direction side = pair.getFirst();
        BlockState block = pair.getSecond();
        switch (((Align)this.orientation).ordinal()) {
            case 0: {
                result.put(this.flipZ(position), Pair.of(this.flipZ(side), this.flipZ(block)));
                break;
            }
            case 1: {
                result.put(this.flipX(position), Pair.of(this.flipX(side), this.flipX(block)));
                break;
            }
        }
        return result;
    }

    @Override
    public Set<BlockPos> process(BlockPos position) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        switch (((Align)this.orientation).ordinal()) {
            case 0: {
                positions.add(this.flipZ(position));
                break;
            }
            case 1: {
                positions.add(this.flipX(position));
                break;
            }
        }
        return positions;
    }

    @Override
    public String typeName() {
        return "plane";
    }

    public static enum Align implements StringRepresentable
    {
        XY("xy"),
        YZ("yz");

        private final String name;

        private Align(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

