/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.zapper;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.zurrtum.create.foundation.item.SwingControlItem;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.packet.s2c.ZapperBeamPacket;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class ZapperItem
extends Item
implements SwingControlItem {
    public ZapperItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay displayComponent, Consumer<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            MutableComponent usedBlock = ((BlockState)stack.get(AllDataComponents.SHAPER_BLOCK_USED)).getBlock().getName();
            tooltip.accept((Component)Component.translatable((String)"create.terrainzapper.usingBlock", (Object[])new Object[]{usedBlock.withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean isZapper(ItemStack newStack) {
        return newStack.getItem() instanceof ZapperItem;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            if (context.getLevel().isClientSide()) {
                this.openHandgunGUI(context.getItemInHand(), context.getHand());
                context.getPlayer().getCooldowns().addCooldown(context.getItemInHand(), 10);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        boolean mainHand;
        ItemStack item = player.getItemInHand(hand);
        boolean bl = mainHand = hand == InteractionHand.MAIN_HAND;
        if (player.isShiftKeyDown()) {
            if (world.isClientSide()) {
                this.openHandgunGUI(item, hand);
                player.getCooldowns().addCooldown(item, 10);
            }
            return InteractionResult.SUCCESS;
        }
        if (ShootableGadgetItemMethods.shouldSwap(player, item, hand, this::isZapper)) {
            return InteractionResult.FAIL;
        }
        Component msg = this.validateUsage(item);
        if (msg != null) {
            AllSoundEvents.DENY.play(world, player, (Vec3i)player.blockPosition());
            player.displayClientMessage((Component)msg.plainCopy().withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        BlockState stateToUse = Blocks.AIR.defaultBlockState();
        if (item.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            stateToUse = (BlockState)item.get(AllDataComponents.SHAPER_BLOCK_USED);
        }
        stateToUse = BlockHelper.setZeroAge(stateToUse);
        CompoundTag data = null;
        if (stateToUse.is(AllBlockTags.SAFE_NBT) && item.has(AllDataComponents.SHAPER_BLOCK_DATA)) {
            data = (CompoundTag)item.get(AllDataComponents.SHAPER_BLOCK_DATA);
        }
        Vec3 start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
        Vec3 range = player.getLookAngle().scale((double)this.getZappingRange(item));
        BlockHitResult raytrace = world.clip(new ClipContext(start, start.add(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos pos = raytrace.getBlockPos();
        BlockState stateReplaced = world.getBlockState(pos);
        if (pos == null || stateReplaced.getBlock() == Blocks.AIR) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            player.stopUsingItem();
            return InteractionResult.SUCCESS;
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, mainHand, new Vec3((double)0.35f, (double)-0.1f, 1.0));
        if (world.isClientSide()) {
            player.stopUsingItem();
            AllClientHandle.INSTANCE.zapperDontAnimateItem(hand);
            return InteractionResult.SUCCESS;
        }
        if (this.activate(world, player, item, stateToUse, raytrace, data)) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            ShootableGadgetItemMethods.sendPackets(player, b -> new ZapperBeamPacket(barrelPos, hand, (boolean)b, raytrace.getLocation()));
        }
        player.stopUsingItem();
        return InteractionResult.SUCCESS;
    }

    public Component validateUsage(ItemStack item) {
        if (!this.canActivateWithoutSelectedBlock(item) && !item.has(AllDataComponents.SHAPER_BLOCK_USED)) {
            return Component.translatable((String)"create.terrainzapper.leftClickToSet");
        }
        return null;
    }

    protected abstract boolean activate(Level var1, Player var2, ItemStack var3, BlockState var4, BlockHitResult var5, CompoundTag var6);

    protected abstract void openHandgunGUI(ItemStack var1, InteractionHand var2);

    protected abstract int getCooldownDelay(ItemStack var1);

    protected abstract int getZappingRange(ItemStack var1);

    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        return false;
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    public boolean canDestroyBlock(ItemStack stack, BlockState state, Level world, BlockPos pos, LivingEntity player) {
        return false;
    }

    public static void setBlockEntityData(Level world, BlockPos pos, BlockState state, CompoundTag data, Player player) {
        BlockEntity blockEntity;
        if (data != null && state.is(AllBlockTags.SAFE_NBT) && (blockEntity = world.getBlockEntity(pos)) != null) {
            if ((data = NBTProcessors.process(state, blockEntity, data, !player.isCreative())) == null) {
                return;
            }
            data.putInt("x", pos.getX());
            data.putInt("y", pos.getY());
            data.putInt("z", pos.getZ());
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), Create.LOGGER);){
                blockEntity.loadWithComponents(TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)data));
            }
        }
    }
}

