/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.spout;

import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.fluids.transfer.FillingInput;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.fluids.transfer.GenericItemFilling;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public class FillingBySpout {
    public static boolean canItemBeFilled(Level world, ItemStack stack) {
        if (world.recipeAccess().propertySet(AllRecipeSets.FILLING).test(stack)) {
            return true;
        }
        return GenericItemFilling.canItemBeFilled(world, stack);
    }

    public static int getRequiredAmountForItem(ServerLevel world, ItemStack stack, FluidStack availableFluid) {
        FillingInput input = new FillingInput(stack, availableFluid);
        Optional findRecipe = world.recipeAccess().getRecipeFor(AllRecipeTypes.FILLING, (RecipeInput)input, (Level)world);
        return findRecipe.map(fillingRecipeRecipeEntry -> ((FillingRecipe)fillingRecipeRecipeEntry.value()).fluidIngredient().amount()).orElseGet(() -> GenericItemFilling.getRequiredAmountForItem((Level)world, stack, availableFluid));
    }

    public static ItemStack fillItem(ServerLevel world, int requiredAmount, ItemStack stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        FillingInput input = new FillingInput(stack, toFill);
        Optional findRecipe = world.recipeAccess().getRecipeFor(AllRecipeTypes.FILLING, (RecipeInput)input, (Level)world);
        if (findRecipe.isPresent()) {
            FillingRecipe recipe = (FillingRecipe)((RecipeHolder)findRecipe.get()).value();
            ItemStack result = recipe.assemble(input, (HolderLookup.Provider)world.registryAccess());
            availableFluid.decrement(recipe.fluidIngredient().amount());
            stack.shrink(1);
            return result;
        }
        return GenericItemFilling.fillItem((Level)world, requiredAmount, stack, availableFluid);
    }
}

