/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics;

import com.zurrtum.create.content.kinetics.TorquePropagator;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KineticNetwork {
    public Long id;
    public boolean initialized;
    public Map<KineticBlockEntity, Float> sources = new HashMap<KineticBlockEntity, Float>();
    public Map<KineticBlockEntity, Float> members = new HashMap<KineticBlockEntity, Float>();
    private float currentCapacity;
    private float currentStress;
    private float unloadedCapacity;
    private float unloadedStress;
    private int unloadedMembers;

    public void initFromTE(float maxStress, float currentStress, int members) {
        this.unloadedCapacity = maxStress;
        this.unloadedStress = currentStress;
        this.unloadedMembers = members;
        this.initialized = true;
        this.updateStress();
        this.updateCapacity();
    }

    public void addSilently(KineticBlockEntity be, float lastCapacity, float lastStress) {
        if (this.members.containsKey(be)) {
            return;
        }
        if (be.isSource()) {
            this.unloadedCapacity -= lastCapacity * KineticNetwork.getStressMultiplierForSpeed(be.getGeneratedSpeed());
            float addedStressCapacity = be.calculateAddedStressCapacity();
            this.sources.put(be, Float.valueOf(addedStressCapacity));
        }
        this.unloadedStress -= lastStress * KineticNetwork.getStressMultiplierForSpeed(be.getTheoreticalSpeed());
        float stressApplied = be.calculateStressApplied();
        this.members.put(be, Float.valueOf(stressApplied));
        --this.unloadedMembers;
        if (this.unloadedMembers < 0) {
            this.unloadedMembers = 0;
        }
        if (this.unloadedCapacity < 0.0f) {
            this.unloadedCapacity = 0.0f;
        }
        if (this.unloadedStress < 0.0f) {
            this.unloadedStress = 0.0f;
        }
    }

    public void add(KineticBlockEntity be) {
        if (this.members.containsKey(be)) {
            return;
        }
        if (be.isSource()) {
            this.sources.put(be, Float.valueOf(be.calculateAddedStressCapacity()));
        }
        this.members.put(be, Float.valueOf(be.calculateStressApplied()));
        this.updateFromNetwork(be);
        be.networkDirty = true;
    }

    public void updateCapacityFor(KineticBlockEntity be, float capacity) {
        this.sources.put(be, Float.valueOf(capacity));
        this.updateCapacity();
    }

    public void updateStressFor(KineticBlockEntity be, float stress) {
        this.members.put(be, Float.valueOf(stress));
        this.updateStress();
    }

    public void remove(KineticBlockEntity be) {
        if (!this.members.containsKey(be)) {
            return;
        }
        if (be.isSource()) {
            this.sources.remove(be);
        }
        this.members.remove(be);
        be.updateFromNetwork(0.0f, 0.0f, 0);
        if (this.members.isEmpty()) {
            TorquePropagator.networks.get(be.getLevel()).remove(this.id);
            return;
        }
        this.members.keySet().stream().findFirst().map(member -> {
            member.networkDirty = true;
            return true;
        });
    }

    public void sync() {
        for (KineticBlockEntity be : this.members.keySet()) {
            this.updateFromNetwork(be);
        }
    }

    private void updateFromNetwork(KineticBlockEntity be) {
        be.updateFromNetwork(this.currentCapacity, this.currentStress, this.getSize());
    }

    public void updateCapacity() {
        float newMaxStress = this.calculateCapacity();
        if (this.currentCapacity != newMaxStress) {
            this.currentCapacity = newMaxStress;
            this.sync();
        }
    }

    public void updateStress() {
        float newStress = this.calculateStress();
        if (this.currentStress != newStress) {
            this.currentStress = newStress;
            this.sync();
        }
    }

    public void updateNetwork() {
        float newStress = this.calculateStress();
        float newMaxStress = this.calculateCapacity();
        if (this.currentStress != newStress || this.currentCapacity != newMaxStress) {
            this.currentStress = newStress;
            this.currentCapacity = newMaxStress;
            this.sync();
        }
    }

    public float calculateCapacity() {
        float presentCapacity = 0.0f;
        Iterator<KineticBlockEntity> iterator = this.sources.keySet().iterator();
        while (iterator.hasNext()) {
            KineticBlockEntity be = iterator.next();
            if (be.getLevel().getBlockEntity(be.getBlockPos()) != be) {
                iterator.remove();
                continue;
            }
            presentCapacity += this.getActualCapacityOf(be);
        }
        float newMaxStress = presentCapacity + this.unloadedCapacity;
        return newMaxStress;
    }

    public float calculateStress() {
        float presentStress = 0.0f;
        Iterator<KineticBlockEntity> iterator = this.members.keySet().iterator();
        while (iterator.hasNext()) {
            KineticBlockEntity be = iterator.next();
            if (be.getLevel().getBlockEntity(be.getBlockPos()) != be) {
                iterator.remove();
                continue;
            }
            presentStress += this.getActualStressOf(be);
        }
        float newStress = presentStress + this.unloadedStress;
        return newStress;
    }

    public float getActualCapacityOf(KineticBlockEntity be) {
        return this.sources.get(be).floatValue() * KineticNetwork.getStressMultiplierForSpeed(be.getGeneratedSpeed());
    }

    public float getActualStressOf(KineticBlockEntity be) {
        return this.members.get(be).floatValue() * KineticNetwork.getStressMultiplierForSpeed(be.getTheoreticalSpeed());
    }

    private static float getStressMultiplierForSpeed(float speed) {
        return Math.abs(speed);
    }

    public int getSize() {
        return this.unloadedMembers + this.members.size();
    }
}

