/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.chainConveyor;

import com.zurrtum.create.infrastructure.packet.s2c.ClientboundChainConveyorRidingPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class ServerChainConveyorHandler {
    public static Object2IntMap<UUID> hangingPlayers = new Object2IntOpenHashMap();
    public static int ticks;

    public static void handleTTLPacket(MinecraftServer server, Player player) {
        int count = hangingPlayers.size();
        hangingPlayers.put((Object)player.getUUID(), 20);
        if (hangingPlayers.size() != count) {
            ServerChainConveyorHandler.sync(server);
        }
    }

    public static void handleStopRidingPacket(MinecraftServer server, Player player) {
        if (hangingPlayers.removeInt((Object)player.getUUID()) != 0) {
            ServerChainConveyorHandler.sync(server);
        }
    }

    public static void tick(MinecraftServer server) {
        ++ticks;
        int before = hangingPlayers.size();
        ObjectIterator iterator = hangingPlayers.object2IntEntrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            int newTTL = (Integer)entry.getValue() - 1;
            if (newTTL <= 0) {
                iterator.remove();
                continue;
            }
            entry.setValue(newTTL);
        }
        int after = hangingPlayers.size();
        if (ticks % 10 != 0 && before == after) {
            return;
        }
        ServerChainConveyorHandler.sync(server);
    }

    public static void sync(MinecraftServer server) {
        server.getPlayerList().broadcastAll((Packet)new ClientboundChainConveyorRidingPacket((Collection<UUID>)hangingPlayers.keySet()));
    }
}

