/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.CrafterHelper;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MechanicalCrafterBlock
extends HorizontalKineticBlock
implements IBE<MechanicalCrafterBlockEntity>,
ICogWheel,
ItemInventoryProvider<MechanicalCrafterBlockEntity>,
NeighborUpdateListeningBlock {
    public static final EnumProperty<Pointing> POINTING = EnumProperty.create((String)"pointing", Pointing.class);

    public MechanicalCrafterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(POINTING, (Comparable)((Object)Pointing.UP)));
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, MechanicalCrafterBlockEntity blockEntity, Direction context) {
        return blockEntity.getInvCapability();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{POINTING}));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getAxis();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos placedOnPos = context.getClickedPos().relative(face.getOpposite());
        BlockState blockState = context.getLevel().getBlockState(placedOnPos);
        if (blockState.getBlock() != this || context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            BlockState stateForPlacement = super.getStateForPlacement(context);
            Direction direction = (Direction)stateForPlacement.getValue((Property)HORIZONTAL_FACING);
            if (direction != face) {
                stateForPlacement = (BlockState)stateForPlacement.setValue(POINTING, (Comparable)((Object)MechanicalCrafterBlock.pointingFromFacing(face, direction)));
            }
            return stateForPlacement;
        }
        Direction otherFacing = (Direction)blockState.getValue((Property)HORIZONTAL_FACING);
        Pointing pointing = MechanicalCrafterBlock.pointingFromFacing(face, otherFacing);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)otherFacing)).setValue(POINTING, (Comparable)((Object)pointing));
    }

    @Override
    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        MechanicalCrafterBlockEntity crafter;
        if (oldState.is((Block)this) && MechanicalCrafterBlock.getTargetDirection(state) != MechanicalCrafterBlock.getTargetDirection(oldState) && (crafter = CrafterHelper.getCrafter((BlockAndTintGetter)worldIn, pos)) != null) {
            crafter.blockChanged();
        }
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel worldIn, BlockPos pos, boolean isMoving) {
        if (state.hasBlockEntity()) {
            MechanicalCrafterBlockEntity crafter = CrafterHelper.getCrafter((BlockAndTintGetter)worldIn, pos);
            if (crafter != null) {
                if (crafter.covered) {
                    Block.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)AllItems.CRAFTER_SLOT_COVER.getDefaultInstance());
                }
                if (!isMoving) {
                    crafter.ejectWholeGrid();
                }
            }
            for (Direction direction : Iterate.directions) {
                if (direction.getAxis() == ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getAxis()) continue;
                BlockPos otherPos = pos.relative(direction);
                ConnectedInputHandler.ConnectedInput thisInput = CrafterHelper.getInput((BlockAndTintGetter)worldIn, pos);
                ConnectedInputHandler.ConnectedInput otherInput = CrafterHelper.getInput((BlockAndTintGetter)worldIn, otherPos);
                if (thisInput == null || otherInput == null || !pos.offset((Vec3i)thisInput.data.getFirst()).equals((Object)otherPos.offset((Vec3i)otherInput.data.getFirst()))) continue;
                ConnectedInputHandler.toggleConnection((Level)worldIn, pos, otherPos);
            }
        }
        super.affectNeighborsAfterRemoval(state, worldIn, pos, isMoving);
    }

    public static Pointing pointingFromFacing(Direction pointingFace, Direction blockFacing) {
        Pointing pointing;
        boolean positive = blockFacing.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        Pointing pointing2 = pointing = pointingFace == Direction.DOWN ? Pointing.UP : Pointing.DOWN;
        if (pointingFace == Direction.EAST) {
            Pointing pointing3 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == Direction.WEST) {
            Pointing pointing4 = pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        if (pointingFace == Direction.NORTH) {
            Pointing pointing5 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == Direction.SOUTH) {
            pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        return pointing;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getClickedFace() == state.getValue((Property)HORIZONTAL_FACING)) {
            if (!context.getLevel().isClientSide()) {
                KineticBlockEntity.switchToBlockState(context.getLevel(), context.getClickedPos(), (BlockState)state.cycle(POINTING));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof MechanicalCrafterBlockEntity)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)blockEntity;
        if (stack.is((Item)AllItems.MECHANICAL_ARM)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        boolean isHand = stack.isEmpty() && hand == InteractionHand.MAIN_HAND;
        boolean wrenched = stack.is((Item)AllItems.WRENCH);
        if (hitResult.getDirection() == state.getValue((Property)HORIZONTAL_FACING)) {
            if (crafter.phase != MechanicalCrafterBlockEntity.Phase.IDLE && !wrenched) {
                crafter.ejectWholeGrid();
                return InteractionResult.SUCCESS;
            }
            if (crafter.phase == MechanicalCrafterBlockEntity.Phase.IDLE && !isHand && !wrenched) {
                if (level.isClientSide()) {
                    return InteractionResult.SUCCESS;
                }
                if (stack.is(AllItems.CRAFTER_SLOT_COVER)) {
                    if (crafter.covered) {
                        return InteractionResult.TRY_WITH_EMPTY_HAND;
                    }
                    if (!crafter.inventory.isEmpty()) {
                        return InteractionResult.TRY_WITH_EMPTY_HAND;
                    }
                    crafter.covered = true;
                    crafter.setChanged();
                    crafter.sendData();
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                Container capability = crafter.getInvCapability();
                if (capability == null) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                int count = stack.getCount();
                int insert = capability.insert(stack);
                if (!player.isCreative()) {
                    if (insert == count) {
                        player.setItemInHand(hand, ItemStack.EMPTY);
                    } else if (insert != 0) {
                        stack.setCount(count - insert);
                        player.setItemInHand(hand, stack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            MechanicalCrafterBlockEntity.CrafterItemHandler handler = crafter.getInventory();
            ItemStack inSlot = handler.getStack();
            if (inSlot.isEmpty()) {
                if (crafter.covered && !wrenched) {
                    if (level.isClientSide()) {
                        return InteractionResult.SUCCESS;
                    }
                    crafter.covered = false;
                    crafter.setChanged();
                    crafter.sendData();
                    if (!player.isCreative()) {
                        player.getInventory().placeItemBackInInventory(AllItems.CRAFTER_SLOT_COVER.getDefaultInstance());
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (!isHand && !handler.matches(stack, inSlot)) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            player.getInventory().placeItemBackInInventory(handler.onExtract(inSlot));
            handler.setStack(ItemStack.EMPTY);
            handler.setChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    public void neighborUpdate(BlockState state, Level worldIn, BlockPos pos, Block sourceBlock, BlockPos fromPos, boolean isMoving) {
        InvManipulationBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.85f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.75f;
    }

    public static Direction getTargetDirection(BlockState state) {
        if (!state.is((Block)AllBlocks.MECHANICAL_CRAFTER)) {
            return Direction.UP;
        }
        Direction facing = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        Pointing point = (Pointing)((Object)state.getValue(POINTING));
        Vec3 targetVec = new Vec3(0.0, 1.0, 0.0);
        targetVec = VecHelper.rotate(targetVec, -point.getXRotation(), Direction.Axis.Z);
        targetVec = VecHelper.rotate(targetVec, AngleHelper.horizontalAngle(facing), Direction.Axis.Y);
        return Direction.getApproximateNearest((double)targetVec.x, (double)targetVec.y, (double)targetVec.z);
    }

    public static boolean isValidTarget(Level world, BlockPos targetPos, BlockState crafterState) {
        BlockState targetState = world.getBlockState(targetPos);
        if (!world.isLoaded(targetPos)) {
            return false;
        }
        if (!targetState.is((Block)AllBlocks.MECHANICAL_CRAFTER)) {
            return false;
        }
        if (crafterState.getValue((Property)HORIZONTAL_FACING) != targetState.getValue((Property)HORIZONTAL_FACING)) {
            return false;
        }
        return Math.abs(((Pointing)((Object)crafterState.getValue(POINTING))).getXRotation() - ((Pointing)((Object)targetState.getValue(POINTING))).getXRotation()) != 180;
    }

    @Override
    public Class<MechanicalCrafterBlockEntity> getBlockEntityClass() {
        return MechanicalCrafterBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends MechanicalCrafterBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MECHANICAL_CRAFTER;
    }
}

