/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerValveScrollValueBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ValveHandleBlockEntity
extends HandCrankBlockEntity {
    public ServerScrollValueBehaviour angleInput;
    public int cooldown;
    public int startAngle;
    public int targetAngle;
    public int totalUseTicks;
    private boolean keepAlive;

    public ValveHandleBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.VALVE_HANDLE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.angleInput = new ServerValveScrollValueBehaviour(this);
        this.angleInput.between(-180, 180);
        this.angleInput.setValue(45);
        behaviours.add(this.angleInput);
    }

    @Override
    protected boolean clockwise() {
        return this.angleInput.getValue() < 0 ^ this.backwards;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putInt("TotalUseTicks", this.totalUseTicks);
        view.putInt("StartAngle", this.startAngle);
        view.putInt("TargetAngle", this.targetAngle);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.totalUseTicks = view.getIntOr("TotalUseTicks", 0);
        this.startAngle = view.getIntOr("StartAngle", 0);
        this.targetAngle = view.getIntOr("TargetAngle", 0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inUse == 0 && this.cooldown > 0) {
            --this.cooldown;
        }
        this.independentAngle = 0.0f;
    }

    public boolean showValue() {
        return this.inUse == 0;
    }

    public boolean activate(boolean sneak) {
        if (this.getTheoreticalSpeed() != 0.0f) {
            return false;
        }
        if (this.inUse > 0 || this.cooldown > 0) {
            return false;
        }
        if (this.level.isClientSide()) {
            return true;
        }
        int value = this.angleInput.getValue();
        int target = Math.abs(value);
        int rotationSpeed = AllBlocks.COPPER_VALVE_HANDLE.getRotationSpeed();
        double degreesPerTick = KineticBlockEntity.convertToAngular(rotationSpeed);
        this.inUse = (int)Math.ceil((double)target / degreesPerTick) + 2;
        this.startAngle = 0;
        this.targetAngle = Math.round((float)(this.startAngle + (target > 135 ? 180 : 90) * Mth.sign((double)value)) / 90.0f) * 90;
        this.totalUseTicks = this.inUse;
        this.backwards = sneak;
        this.sequenceContext = SequencedGearshiftBlockEntity.SequenceContext.fromGearshift(SequencerInstructions.TURN_ANGLE, rotationSpeed, target);
        this.updateGeneratedRotation();
        this.cooldown = 4;
        return true;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        BlockState state = this.level.getBlockState(pos);
        if (this.getType().isValid(state)) {
            this.keepAlive = true;
            this.setBlockState(state);
        } else {
            super.preRemoveSideEffects(pos, oldState);
        }
    }

    @Override
    public void setRemoved() {
        if (this.keepAlive) {
            this.keepAlive = false;
            this.level.getChunk(this.worldPosition).setBlockEntity((BlockEntity)this);
        } else {
            super.setRemoved();
        }
    }
}

