/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockItem;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperItem;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.villager.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DeployerHandler {
    private static final Map<BlockPos, List<ItemEntity>> CAPTURED_BLOCK_DROPS = new HashMap<BlockPos, List<ItemEntity>>();
    public static final Map<BlockPos, List<ItemEntity>> CAPTURED_BLOCK_DROPS_VIEW = Collections.unmodifiableMap(CAPTURED_BLOCK_DROPS);

    static boolean shouldActivate(ItemStack held, Level world, BlockPos targetPos, @Nullable Direction facing) {
        if (held.getItem() instanceof BlockItem && world.getBlockState(targetPos).getBlock() == ((BlockItem)held.getItem()).getBlock()) {
            return false;
        }
        Item item = held.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            Fluid fluid = bucketItem.content;
            if (fluid != Fluids.EMPTY && world.getFluidState(targetPos).getType() == fluid) {
                return false;
            }
        }
        return held.isEmpty() || facing != Direction.DOWN || BlockEntityBehaviour.get((BlockGetter)world, targetPos, TransportedItemStackHandlerBehaviour.TYPE) == null;
    }

    static void activate(DeployerPlayer player, Vec3 vec, BlockPos clickedPos, Vec3 extensionVector, DeployerBlockEntity.Mode mode) {
        ServerPlayer serverPlayer = player.cast();
        HashMultimap attributeModifiers = HashMultimap.create();
        ItemStack stack = serverPlayer.getMainHandItem();
        ((ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).modifiers().forEach(e -> attributeModifiers.put((Object)e.attribute(), (Object)e.modifier()));
        serverPlayer.getAttributes().addTransientAttributeModifiers((Multimap)attributeModifiers);
        DeployerHandler.activateInner(player, vec, clickedPos, extensionVector, mode);
        serverPlayer.getAttributes().removeAttributeModifiers((Multimap)attributeModifiers);
    }

    private static void activateInner(DeployerPlayer player, Vec3 vec, BlockPos clickedPos, Vec3 extensionVector, DeployerBlockEntity.Mode mode) {
        SandPaperItemComponent component;
        InteractionResult.Success success;
        ItemStack resultStack;
        InteractionResult onItemRightClick;
        InteractionResult onItemUse;
        boolean flag1;
        ClipContext rayTraceContext;
        BlockHitResult result;
        ServerPlayer serverPlayer = player.cast();
        Vec3 rayOrigin = vec.add(extensionVector.scale(1.515625));
        Vec3 rayTarget = vec.add(extensionVector.scale(2.484375));
        serverPlayer.setPos(rayOrigin.x, rayOrigin.y, rayOrigin.z);
        BlockPos pos = BlockPos.containing((Position)vec);
        ItemStack stack = serverPlayer.getMainHandItem();
        Item item = stack.getItem();
        ServerLevel level = serverPlayer.level();
        List<Entity> entities = level.getEntitiesOfClass(Entity.class, new AABB(clickedPos)).stream().filter(e -> !(e instanceof AbstractContraptionEntity)).toList();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!entities.isEmpty()) {
            Entity entity = entities.get(level.random.nextInt(entities.size()));
            ArrayList capturedDrops = new ArrayList();
            boolean success2 = false;
            AllSynchedDatas.CAPTURE_DROPS.set(entity, Optional.of(capturedDrops));
            if (mode == DeployerBlockEntity.Mode.USE) {
                Object cancelResult = null;
                if (cancelResult == null) {
                    LivingEntity livingEntity;
                    if (entity.interact((Player)serverPlayer, hand).consumesAction()) {
                        AbstractVillager villager;
                        if (entity instanceof AbstractVillager && (villager = (AbstractVillager)entity).getTradingPlayer() == serverPlayer) {
                            villager.setTradingPlayer(null);
                        }
                        success2 = true;
                    } else if (entity instanceof LivingEntity && stack.interactLivingEntity((Player)serverPlayer, livingEntity = (LivingEntity)entity, hand).consumesAction()) {
                        success2 = true;
                    }
                }
                if (!success2 && entity instanceof Player) {
                    FoodProperties foodProperties;
                    Player playerEntity = (Player)entity;
                    if (stack.has(DataComponents.FOOD) && (foodProperties = (FoodProperties)stack.get(DataComponents.FOOD)) != null && playerEntity.canEat(foodProperties.canAlwaysEat())) {
                        ItemStack copy = stack.copy();
                        serverPlayer.setItemInHand(hand, stack.finishUsingItem((Level)level, (LivingEntity)playerEntity));
                        player.setSpawnedItemEffects(copy);
                        success2 = true;
                    }
                    if (!success2 && stack.is(AllItemTags.DEPLOYABLE_DRINK)) {
                        player.setSpawnedItemEffects(stack.copy());
                        serverPlayer.setItemInHand(hand, stack.finishUsingItem((Level)level, (LivingEntity)playerEntity));
                        success2 = true;
                    }
                }
            }
            if (mode == DeployerBlockEntity.Mode.PUNCH) {
                serverPlayer.resetAttackStrengthTicker();
                serverPlayer.attack(entity);
                success2 = true;
            }
            AllSynchedDatas.CAPTURE_DROPS.set(entity, Optional.empty());
            capturedDrops.forEach(e -> serverPlayer.getInventory().placeItemBackInInventory(e));
            if (success2) {
                return;
            }
        }
        if ((result = level.clip(rayTraceContext = new ClipContext(rayOrigin, rayTarget, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)serverPlayer))).getBlockPos() != clickedPos) {
            result = new BlockHitResult(result.getLocation(), result.getDirection(), clickedPos, result.isInside());
        }
        BlockState clickedState = level.getBlockState(clickedPos);
        Direction face = result.getDirection();
        if (face == null) {
            face = Direction.getApproximateNearest((double)extensionVector.x, (double)extensionVector.y, (double)extensionVector.z).getOpposite();
        }
        if (mode == DeployerBlockEntity.Mode.PUNCH) {
            if (!level.mayInteract((Entity)serverPlayer, clickedPos)) {
                return;
            }
            if (clickedState.getShape((BlockGetter)level, clickedPos).isEmpty()) {
                player.setBlockBreakingProgress(null);
                return;
            }
            if (BlockHelper.extinguishFire((Level)level, (Player)serverPlayer, clickedPos, face)) {
                return;
            }
            if (stack.isEmpty()) {
                return;
            }
            float progress = clickedState.getDestroyProgress((Player)serverPlayer, (BlockGetter)level, clickedPos) * 16.0f;
            float before = 0.0f;
            Pair<BlockPos, Float> blockBreakingProgress = player.getBlockBreakingProgress();
            if (blockBreakingProgress != null) {
                before = ((Float)blockBreakingProgress.getValue()).floatValue();
            }
            progress += before;
            level.playSound(null, clickedPos, clickedState.getSoundType().getHitSound(), SoundSource.NEUTRAL, 0.25f, 1.0f);
            if (progress >= 1.0f) {
                DeployerHandler.tryHarvestBlock(player, player.getInteractionManager(), clickedPos);
                level.destroyBlockProgress(serverPlayer.getId(), clickedPos, -1);
                player.setBlockBreakingProgress(null);
                return;
            }
            if (progress <= 0.0f) {
                player.setBlockBreakingProgress(null);
                return;
            }
            if ((int)(before * 10.0f) != (int)(progress * 10.0f)) {
                level.destroyBlockProgress(serverPlayer.getId(), clickedPos, (int)(progress * 10.0f));
            }
            player.setBlockBreakingProgress((Pair<BlockPos, Float>)Pair.of((Object)clickedPos, (Object)Float.valueOf(progress)));
            return;
        }
        UseOnContext itemusecontext = new UseOnContext((Player)serverPlayer, hand, result);
        boolean holdingSomething = !serverPlayer.getMainHandItem().isEmpty();
        boolean bl = flag1 = !serverPlayer.isShiftKeyDown() || !holdingSomething || !serverPlayer.getMainHandItem().isEmpty();
        if (flag1 && DeployerHandler.safeOnUse(clickedState, (Level)level, clickedPos, player, hand, result).consumesAction()) {
            return;
        }
        if (stack.isEmpty()) {
            return;
        }
        if (item instanceof CartAssemblerBlockItem && clickedState.canBeReplaced(new BlockPlaceContext(itemusecontext))) {
            return;
        }
        if (item == Items.FLINT_AND_STEEL) {
            Direction newFace = result.getDirection();
            BlockPos newPos = result.getBlockPos();
            if (!BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)clickedPos, (Direction)newFace)) {
                newFace = Direction.UP;
            }
            if (clickedState.isAir()) {
                newPos = newPos.relative(face.getOpposite());
            }
            result = new BlockHitResult(result.getLocation(), newFace, newPos, result.isInside());
            itemusecontext = new UseOnContext((Player)serverPlayer, hand, result);
        }
        if ((onItemUse = stack.useOn(itemusecontext)).consumesAction()) {
            BlockItem bi;
            if (item instanceof BlockItem && ((bi = (BlockItem)item).getBlock() instanceof BaseRailBlock || bi.getBlock() instanceof ITrackBlock)) {
                player.setPlacedTracks(true);
            }
            return;
        }
        if (item == Items.ENDER_PEARL) {
            return;
        }
        if (item.builtInRegistryHolder().is(AllItemTags.DEPLOYABLE_DRINK)) {
            return;
        }
        Object itemUseWorld = level;
        if (item instanceof BucketItem || item instanceof SandPaperItem) {
            itemUseWorld = new ItemUseWorld(level, face, pos);
        }
        if ((onItemRightClick = item.use((Level)itemUseWorld, (Player)serverPlayer, hand)).consumesAction() && item instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)item;
            bucketItem.checkExtraContent((LivingEntity)serverPlayer, (Level)level, stack, clickedPos);
        }
        if (onItemRightClick instanceof InteractionResult.Success && ((resultStack = (success = (InteractionResult.Success)onItemRightClick).heldItemTransformedTo()) != null && resultStack != stack || resultStack.getCount() != stack.getCount() || resultStack.getUseDuration((LivingEntity)serverPlayer) > 0 || resultStack.getDamageValue() != stack.getDamageValue())) {
            serverPlayer.setItemInHand(hand, resultStack);
        }
        if (stack.getItem() instanceof SandPaperItem && (component = (SandPaperItemComponent)stack.get(AllDataComponents.SAND_PAPER_POLISHING)) != null) {
            player.setSpawnedItemEffects(component.item());
            AllSoundEvents.SANDING_SHORT.playOnServer((Level)level, (Vec3i)pos, 0.25f, 1.0f);
        }
        if (!serverPlayer.getUseItem().isEmpty()) {
            serverPlayer.setItemInHand(hand, stack.finishUsingItem((Level)level, (LivingEntity)serverPlayer));
        }
        serverPlayer.stopUsingItem();
    }

    public static boolean tryHarvestBlock(DeployerPlayer player, ServerPlayerGameMode interactionManager, BlockPos pos) {
        ServerPlayer serverPlayer = player.cast();
        ServerLevel world = serverPlayer.level();
        BlockState blockstate = world.getBlockState(pos);
        GameType gameType = interactionManager.getGameModeForPlayer();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (serverPlayer.blockActionRestricted((Level)world, pos, gameType)) {
            return false;
        }
        ItemStack prevHeldItem = serverPlayer.getMainHandItem();
        ItemStack heldItem = prevHeldItem.copy();
        boolean canHarvest = serverPlayer.hasCorrectToolForDrops(blockstate) && serverPlayer.mayBuild();
        prevHeldItem.mineBlock((Level)world, blockstate, pos, (Player)player.cast());
        BlockPos posUp = pos.above();
        BlockState stateUp = world.getBlockState(posUp);
        if (blockstate.getBlock() instanceof DoublePlantBlock && blockstate.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER && stateUp.getBlock() == blockstate.getBlock() && stateUp.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 35);
            world.setBlock(posUp, Blocks.AIR.defaultBlockState(), 35);
        } else {
            blockstate.getBlock().playerWillDestroy((Level)world, pos, blockstate, (Player)player.cast());
            if (!world.setBlock(pos, world.getFluidState(pos).getType().defaultFluidState().createLegacyBlock(), world.isClientSide() ? 11 : 3)) {
                return true;
            }
        }
        blockstate.getBlock().destroy((LevelAccessor)world, pos, blockstate);
        if (!canHarvest) {
            return true;
        }
        Block.getDrops((BlockState)blockstate, (ServerLevel)world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player.cast(), (ItemStack)prevHeldItem).forEach(item -> serverPlayer.getInventory().placeItemBackInInventory(item));
        blockstate.spawnAfterBreak(world, pos, prevHeldItem, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractionResult safeOnUse(BlockState state, Level world, BlockPos pos, DeployerPlayer player, InteractionHand hand, BlockHitResult ray) {
        ArrayList drops = new ArrayList(4);
        CAPTURED_BLOCK_DROPS.put(pos, drops);
        try {
            InteractionResult result = BlockHelper.invokeUse(state, world, (Player)player.cast(), hand, ray);
            for (ItemEntity itemEntity : drops) {
                player.cast().getInventory().placeItemBackInInventory(itemEntity.getItem());
            }
            InteractionResult interactionResult = result;
            return interactionResult;
        }
        finally {
            CAPTURED_BLOCK_DROPS.remove(pos);
        }
    }

    private static final class ItemUseWorld
    extends WrappedLevel
    implements ServerLevelAccessor {
        private final Direction face;
        private final BlockPos pos;
        boolean rayMode = false;

        private ItemUseWorld(ServerLevel level, Direction face, BlockPos pos) {
            super((Level)level);
            this.face = face;
            this.pos = pos;
        }

        public DifficultyInstance getCurrentDifficultyAt(BlockPos pos) {
            return this.getLevel().getCurrentDifficultyAt(pos);
        }

        public ServerLevel getLevel() {
            return (ServerLevel)this.level;
        }

        public BlockHitResult clip(ClipContext context) {
            this.rayMode = true;
            BlockHitResult rayTraceBlocks = super.clip(context);
            this.rayMode = false;
            return rayTraceBlocks;
        }

        @Override
        public BlockState getBlockState(BlockPos position) {
            if (this.rayMode && (this.pos.relative(this.face.getOpposite(), 3).equals((Object)position) || this.pos.relative(this.face.getOpposite(), 1).equals((Object)position))) {
                return Blocks.BEDROCK.defaultBlockState();
            }
            return this.level.getBlockState(position);
        }
    }
}

