/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationInput;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.component.SequencedAssemblyJunk;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public interface ItemApplicationRecipe
extends CreateRecipe<ItemApplicationInput> {
    public ItemStack result();

    public boolean keepHeldItem();

    public Ingredient target();

    public Ingredient ingredient();

    default public boolean matches(ItemApplicationInput input, Level world) {
        return this.target().test(input.target()) && this.ingredient().test(input.ingredient());
    }

    default public ItemStack assemble(ItemApplicationInput input, HolderLookup.Provider registries) {
        SequencedAssemblyJunk junk = (SequencedAssemblyJunk)input.target().get(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK);
        if (junk != null && junk.hasJunk()) {
            return junk.getJunk();
        }
        return this.result().copy();
    }

    public record Serializer<T extends ItemApplicationRecipe>(MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) implements RecipeSerializer<T>
    {
        public Serializer(Factory<T> factory) {
            this(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(ItemApplicationRecipe::result), (App)Codec.BOOL.optionalFieldOf("keep_held_item", (Object)false).forGetter(ItemApplicationRecipe::keepHeldItem), (App)Ingredient.CODEC.fieldOf("target").forGetter(ItemApplicationRecipe::target), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(ItemApplicationRecipe::ingredient)).apply((Applicative)instance, factory::create)), StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ItemApplicationRecipe::result, (StreamCodec)ByteBufCodecs.BOOL, ItemApplicationRecipe::keepHeldItem, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ItemApplicationRecipe::target, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ItemApplicationRecipe::ingredient, factory::create));
        }

        public static interface Factory<T extends ItemApplicationRecipe> {
            public T create(ItemStack var1, boolean var2, Ingredient var3, Ingredient var4);
        }
    }
}

