/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.fan.processing;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllFluidTags;
import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.LitBlazeBurnerBlock;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.foundation.recipe.RecipeApplier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.equine.Horse;
import net.minecraft.world.entity.animal.equine.SkeletonHorse;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AllFanProcessingTypes {
    public static final BlastingType BLASTING = AllFanProcessingTypes.register("blasting", new BlastingType());
    public static final HauntingType HAUNTING = AllFanProcessingTypes.register("haunting", new HauntingType());
    public static final SmokingType SMOKING = AllFanProcessingTypes.register("smoking", new SmokingType());
    public static final SplashingType SPLASHING = AllFanProcessingTypes.register("splashing", new SplashingType());

    private static <T extends FanProcessingType> T register(String name, T type) {
        return (T)((FanProcessingType)Registry.register(CreateRegistries.FAN_PROCESSING_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)name), type));
    }

    public static void register() {
    }

    public static class BlastingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.is(AllFluidTags.FAN_PROCESSING_CATALYSTS_BLASTING)) {
                return true;
            }
            BlockState blockState = level.getBlockState(pos);
            if (blockState.is(AllBlockTags.FAN_PROCESSING_CATALYSTS_BLASTING)) {
                return !blockState.hasProperty(BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)((Object)blockState.getValue(BlazeBurnerBlock.HEAT_LEVEL))).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            SingleRecipeInput input = new SingleRecipeInput(stack);
            RecipeManager recipeManager = ((ServerLevel)level).recipeAccess();
            Optional<RecipeHolder<?>> smeltingRecipe = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (smeltingRecipe.isPresent()) {
                return true;
            }
            Optional<RecipeHolder<?>> blastingRecipe = recipeManager.getRecipeFor(RecipeType.BLASTING, (RecipeInput)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (blastingRecipe.isPresent()) {
                return true;
            }
            return !stack.has(DataComponents.DAMAGE_RESISTANT);
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SingleRecipeInput input = new SingleRecipeInput(stack);
            RecipeManager recipeManager = ((ServerLevel)level).recipeAccess();
            Optional<RecipeHolder<?>> smeltingRecipe = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            if (smeltingRecipe.isEmpty()) {
                smeltingRecipe = recipeManager.getRecipeFor(RecipeType.BLASTING, (RecipeInput)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
            }
            if (smeltingRecipe.isPresent()) {
                Optional<RecipeHolder<?>> smokingRecipe = recipeManager.getRecipeFor(RecipeType.SMOKING, (RecipeInput)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED);
                RegistryAccess registryAccess = level.registryAccess();
                if (smokingRecipe.isEmpty() || !ItemStack.isSameItem((ItemStack)((SmokingRecipe)smokingRecipe.get().value()).assemble(input, (HolderLookup.Provider)registryAccess), (ItemStack)smeltingRecipe.get().value().assemble((RecipeInput)input, (HolderLookup.Provider)registryAccess))) {
                    return RecipeApplier.applyRecipeOn(level, stack.getCount(), input, smeltingRecipe.get(), false);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors(0xFF4400, 0xFF8855, random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.FLAME, 0.25f);
            }
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.LAVA.defaultBlockState()), 0.25f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide()) {
                return;
            }
            if (!entity.fireImmune()) {
                entity.igniteForSeconds(10.0f);
                entity.hurtServer((ServerLevel)level, AllDamageSources.get((Level)level).fan_lava, 4.0f);
            }
        }
    }

    public static class HauntingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.is(AllFluidTags.FAN_PROCESSING_CATALYSTS_HAUNTING)) {
                return true;
            }
            BlockState blockState = level.getBlockState(pos);
            if (blockState.is(AllBlockTags.FAN_PROCESSING_CATALYSTS_HAUNTING)) {
                if (blockState.is(BlockTags.CAMPFIRES) && blockState.hasProperty((Property)CampfireBlock.LIT) && !((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                    return false;
                }
                return !blockState.hasProperty(LitBlazeBurnerBlock.FLAME_TYPE) || blockState.getValue(LitBlazeBurnerBlock.FLAME_TYPE) == LitBlazeBurnerBlock.FlameType.SOUL;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 300;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            return level.recipeAccess().propertySet(AllRecipeSets.HAUNTING).test(stack);
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SingleRecipeInput input = new SingleRecipeInput(stack);
            Optional recipe = ((ServerLevel)level).recipeAccess().getRecipeFor(AllRecipeTypes.HAUNTING, (RecipeInput)input, level);
            return recipe.map(entry -> RecipeApplier.applyCreateRecipeOn(level, stack.getCount(), input, (CreateRecipe)entry.value(), true)).orElse(null);
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            pos = pos.add(VecHelper.offsetRandomly(Vec3.ZERO, level.random, 1.0f).multiply(1.0, (double)0.05f, 1.0).normalize().scale((double)0.15f));
            level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.x, pos.y + (double)0.45f, pos.z, 0.0, 0.0, 0.0);
            if (level.random.nextInt(2) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors(0, 1205608, random.nextFloat()));
            particleAccess.setAlpha(1.0f);
            if (random.nextFloat() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, 0.125f);
            }
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SMOKE, 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide()) {
                if (entity instanceof Horse) {
                    Vec3 p = entity.getPosition(0.0f);
                    Vec3 v = p.add(0.0, 0.5, 0.0).add(VecHelper.offsetRandomly(Vec3.ZERO, level.random, 1.0f).multiply(1.0, (double)0.2f, 1.0).normalize().scale(1.0));
                    level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, v.x, v.y, v.z, 0.0, (double)0.1f, 0.0);
                    if (level.random.nextInt(3) == 0) {
                        level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, p.x, p.y + 0.5, p.z, (double)((level.random.nextFloat() - 0.5f) * 0.5f), (double)0.1f, (double)((level.random.nextFloat() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 30, 0, false, false));
                livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 20, 1, false, false));
            }
            if (entity instanceof Horse) {
                Horse horse = (Horse)entity;
                int progress = AllSynchedDatas.HAUNTING.get((Entity)horse);
                if (progress < 100) {
                    if (progress % 10 == 0) {
                        level.playSound(null, entity.blockPosition(), (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 100.0f);
                    }
                    AllSynchedDatas.HAUNTING.set((Entity)horse, progress + 1);
                    return;
                }
                level.playSound(null, entity.blockPosition(), SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.NEUTRAL, 1.25f, 0.65f);
                SkeletonHorse skeletonHorse = (SkeletonHorse)EntityType.SKELETON_HORSE.create(level, EntitySpawnReason.NATURAL);
                RegistryAccess registryManager = level.registryAccess();
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(skeletonHorse.problemPath(), Create.LOGGER);){
                    TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)registryManager);
                    horse.saveWithoutId((ValueOutput)view);
                    CompoundTag serializeNBT = view.buildResult();
                    serializeNBT.remove("UUID");
                    skeletonHorse.load(TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)registryManager, (CompoundTag)serializeNBT));
                }
                if (!horse.getBodyArmorItem().isEmpty()) {
                    horse.spawnAtLocation((ServerLevel)level, horse.getBodyArmorItem());
                }
                skeletonHorse.setPos(horse.getPosition(0.0f));
                level.addFreshEntity((Entity)skeletonHorse);
                horse.discard();
            }
        }
    }

    public static class SmokingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.is(AllFluidTags.FAN_PROCESSING_CATALYSTS_SMOKING)) {
                return true;
            }
            BlockState blockState = level.getBlockState(pos);
            if (blockState.is(AllBlockTags.FAN_PROCESSING_CATALYSTS_SMOKING)) {
                if (blockState.is(BlockTags.CAMPFIRES) && blockState.hasProperty((Property)CampfireBlock.LIT) && !((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                    return false;
                }
                if (blockState.hasProperty(LitBlazeBurnerBlock.FLAME_TYPE) && blockState.getValue(LitBlazeBurnerBlock.FLAME_TYPE) != LitBlazeBurnerBlock.FlameType.REGULAR) {
                    return false;
                }
                return !blockState.hasProperty(BlazeBurnerBlock.HEAT_LEVEL) || blockState.getValue(BlazeBurnerBlock.HEAT_LEVEL) == BlazeBurnerBlock.HeatLevel.SMOULDERING;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return 200;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            return ((ServerLevel)level).recipeAccess().getRecipeFor(RecipeType.SMOKING, (RecipeInput)new SingleRecipeInput(stack), level).filter(AllRecipeTypes.CAN_BE_AUTOMATED).isPresent();
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SingleRecipeInput input = new SingleRecipeInput(stack);
            return ((ServerLevel)level).recipeAccess().getRecipeFor(RecipeType.SMOKING, (RecipeInput)input, level).filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(entry -> RecipeApplier.applyRecipeOn(level, stack.getCount(), input, entry, false)).orElse(null);
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors(0, 0x555555, random.nextFloat()));
            particleAccess.setAlpha(1.0f);
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SMOKE, 0.125f);
            }
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide()) {
                return;
            }
            if (!entity.fireImmune()) {
                entity.igniteForSeconds(2.0f);
                entity.hurtServer((ServerLevel)level, AllDamageSources.get((Level)level).fan_fire, 2.0f);
            }
        }
    }

    public static class SplashingType
    implements FanProcessingType {
        @Override
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.is(AllFluidTags.FAN_PROCESSING_CATALYSTS_SPLASHING)) {
                return true;
            }
            BlockState blockState = level.getBlockState(pos);
            return blockState.is(AllBlockTags.FAN_PROCESSING_CATALYSTS_SPLASHING);
        }

        @Override
        public int getPriority() {
            return 400;
        }

        @Override
        public boolean canProcess(ItemStack stack, Level level) {
            return level.recipeAccess().propertySet(AllRecipeSets.SPLASHING).test(stack);
        }

        @Override
        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SingleRecipeInput input = new SingleRecipeInput(stack);
            return ((ServerLevel)level).recipeAccess().getRecipeFor(AllRecipeTypes.SPLASHING, (RecipeInput)input, level).map(entry -> RecipeApplier.applyCreateRecipeOn(level, stack.getCount(), input, (CreateRecipe)entry.value(), true)).orElse(null);
        }

        @Override
        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)new DustParticleOptions(22015, 1.0f), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SPIT, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        @Override
        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors(0x4499FF, 0x2277FF, random.nextFloat()));
            particleAccess.setAlpha(1.0f);
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.BUBBLE, 0.125f);
            }
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, 0.125f);
            }
        }

        @Override
        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide()) {
                return;
            }
            if (entity instanceof EnderMan || entity.getType() == EntityType.SNOW_GOLEM || entity.getType() == EntityType.BLAZE) {
                entity.hurtServer((ServerLevel)level, entity.damageSources().drown(), 2.0f);
            }
            if (entity.isOnFire()) {
                entity.clearFire();
                level.playSound(null, entity.blockPosition(), SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
            }
        }
    }
}

