/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.fan.processing;

import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FanProcessing {
    public static boolean canProcess(ItemEntity entity, FanProcessingType type) {
        String itemType = AllSynchedDatas.ITEM_TYPE.get((Entity)entity);
        if (!itemType.isEmpty()) {
            if (FanProcessingType.parse(itemType) != type) {
                return type.canProcess(entity.getItem(), entity.level());
            }
            return AllSynchedDatas.ITEM_TIME.get((Entity)entity) != -1;
        }
        return type.canProcess(entity.getItem(), entity.level());
    }

    public static boolean applyProcessing(ItemEntity entity, FanProcessingType type) {
        if (FanProcessing.decrementProcessingTime(entity, type) != 0) {
            return false;
        }
        List<ItemStack> stacks = type.process(entity.getItem(), entity.level());
        if (stacks == null) {
            return false;
        }
        if (stacks.isEmpty()) {
            entity.discard();
            return false;
        }
        entity.setItem(stacks.removeFirst());
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), additional);
            entityIn.setDeltaMovement(entity.getDeltaMovement());
            entity.level().addFreshEntity((Entity)entityIn);
        }
        return true;
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(TransportedItemStack transported, Level world, FanProcessingType type) {
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.getCount() - 1) / 16 + 1;
            transported.processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
            if (!type.canProcess(transported.stack, world)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List<ItemStack> stacks = type.process(transported.stack, world);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
        for (ItemStack additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.copy();
            transportedStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static int decrementProcessingTime(ItemEntity entity, FanProcessingType type) {
        int time;
        String itemType = AllSynchedDatas.ITEM_TYPE.get((Entity)entity);
        if (itemType.isEmpty() || FanProcessingType.parse(itemType) != type) {
            Identifier key = CreateRegistries.FAN_PROCESSING_TYPE.getKey((Object)type);
            if (key == null) {
                throw new IllegalArgumentException("Could not get id for FanProcessingType " + String.valueOf(type) + "!");
            }
            AllSynchedDatas.ITEM_TYPE.set((Entity)entity, key.toString());
            int timeModifierForStackSize = (entity.getItem().getCount() - 1) / 16 + 1;
            time = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize;
        } else {
            time = AllSynchedDatas.ITEM_TIME.get((Entity)entity) - 1;
        }
        AllSynchedDatas.ITEM_TIME.set((Entity)entity, time);
        return time;
    }
}

