/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.saw;

import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.kinetics.saw.TreeCutter;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SawMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.getValue((Property)SawBlock.FACING)).getOpposite());
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)SawBlock.FACING)).getUnitVec3i()).scale((double)0.65f);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        Vec3 facingVec = Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)SawBlock.FACING)).getUnitVec3i());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.getApproximateNearest((double)facingVec.x, (double)facingVec.y, (double)facingVec.z);
        if (closestToFacing.getAxis().isVertical() && context.data.contains("BreakingPos")) {
            context.data.remove("BreakingPos");
            context.stall = false;
        }
    }

    @Override
    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        return super.canBreak(world, breakingPos, state) && SawBlockEntity.isSawable(state);
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        if (brokenState.is(BlockTags.LEAVES)) {
            return;
        }
        TreeCutter.findTree((BlockGetter)context.world, pos, brokenState).destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (BlockPos)stack, (ItemStack)dropPos));
    }

    public void dropItemFromCutTree(MovementContext context, BlockPos pos, ItemStack stack) {
        CombinedInvWrapper inventory = context.contraption.getStorage().getAllItems();
        int count = stack.getCount();
        int insert = inventory.insert(stack);
        if (insert == count) {
            return;
        }
        Level world = context.world;
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        float distance = context.position == null ? 1.0f : (float)dropPos.distanceTo(context.position);
        stack.setCount(count - insert);
        ItemEntity entity = new ItemEntity(world, dropPos.x, dropPos.y, dropPos.z, stack);
        entity.setDeltaMovement(context.relativeMotion.scale((double)(distance / 20.0f)));
        world.addFreshEntity((Entity)entity);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    protected boolean shouldDestroyStartBlock(BlockState stateToBreak) {
        return true;
    }

    @Override
    protected DamageSource getDamageSource(Level level) {
        return AllDamageSources.get((Level)level).saw;
    }
}

