/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.transmission.sequencer;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SequencedGearshiftBlock
extends HorizontalAxisKineticBlock
implements IBE<SequencedGearshiftBlockEntity>,
TransformableBlock,
WeakPowerControlBlock {
    public static final BooleanProperty VERTICAL = BooleanProperty.create((String)"vertical");
    public static final IntegerProperty STATE = IntegerProperty.create((String)"state", (int)0, (int)5);

    public SequencedGearshiftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{STATE, VERTICAL}));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation wireOrientation, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        if (!level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        boolean previouslyPowered = (Integer)state.getValue((Property)STATE) != 0;
        boolean isPowered = worldIn.hasNeighborSignal(pos);
        this.withBlockEntityDo((BlockGetter)worldIn, pos, sgte -> sgte.onRedstoneUpdate(isPowered, previouslyPowered));
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return false;
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (((Boolean)state.getValue((Property)VERTICAL)).booleanValue()) {
            return face.getAxis().isVertical();
        }
        return super.hasShaftTowards(world, pos, state, face);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockItem blockItem;
        if (stack.is((Item)AllItems.WRENCH)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof KineticBlock && this.hasShaftTowards((LevelReader)level, pos, state, hitResult.getDirection())) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (level.isClientSide()) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> AllClientHandle.INSTANCE.openSequencedGearshiftScreen((SequencedGearshiftBlockEntity)be));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis preferredAxis = RotatedPillarKineticBlock.getPreferredAxis(context);
        if (!(preferredAxis == null || context.getPlayer() != null && context.getPlayer().isShiftKeyDown())) {
            return this.withAxis(preferredAxis, context);
        }
        return this.withAxis(context.getNearestLookingDirection().getAxis(), context);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockState newState = state;
        if (context.getClickedFace().getAxis() != Direction.Axis.Y && newState.getValue((Property)HORIZONTAL_AXIS) != context.getClickedFace().getAxis()) {
            newState = (BlockState)newState.cycle((Property)VERTICAL);
        }
        return super.onWrenched(newState, context);
    }

    @Override
    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    private BlockState withAxis(Direction.Axis axis, BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(axis.isVertical()));
        if (axis.isVertical()) {
            return (BlockState)state.setValue((Property)HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis());
        }
        return (BlockState)state.setValue((Property)HORIZONTAL_AXIS, (Comparable)axis);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        if (((Boolean)state.getValue((Property)VERTICAL)).booleanValue()) {
            return Direction.Axis.Y;
        }
        return super.getRotationAxis(state);
    }

    @Override
    public Class<SequencedGearshiftBlockEntity> getBlockEntityClass() {
        return SequencedGearshiftBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends SequencedGearshiftBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.SEQUENCED_GEARSHIFT;
    }

    public boolean hasAnalogOutputSignal(BlockState p_149740_1_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos, Direction direction) {
        return (Integer)state.getValue((Property)STATE);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.mirror(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.rotate(state, transform.rotation);
        }
        if (transform.rotation.ordinal() % 2 == 1) {
            if (transform.rotationAxis != state.getValue((Property)HORIZONTAL_AXIS)) {
                return (BlockState)state.cycle((Property)VERTICAL);
            }
            if (((Boolean)state.getValue((Property)VERTICAL)).booleanValue()) {
                return (BlockState)((BlockState)state.cycle((Property)VERTICAL)).cycle((Property)HORIZONTAL_AXIS);
            }
        }
        return state;
    }
}

