/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.transmission.sequencer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.Instruction;
import com.zurrtum.create.content.kinetics.transmission.sequencer.OnIsPoweredResult;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SequencedGearshiftBlockEntity
extends SplitShaftBlockEntity {
    public Vector<Instruction> instructions = Instruction.createDefault();
    int currentInstruction = -1;
    int currentInstructionDuration = -1;
    float currentInstructionProgress = 0.0f;
    int timer = 0;
    boolean poweredPreviously = false;

    public SequencedGearshiftBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SEQUENCED_GEARSHIFT, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isIdle()) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (this.currentInstructionDuration < 0) {
            return;
        }
        if (this.timer < this.currentInstructionDuration) {
            ++this.timer;
            this.currentInstructionProgress += this.getInstruction(this.currentInstruction).getTickProgress(this.speed);
            return;
        }
        this.run(this.currentInstruction + 1);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.isIdle()) {
            return;
        }
        float currentSpeed = Math.abs(this.speed);
        if (Math.abs(previousSpeed) == currentSpeed) {
            return;
        }
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            this.run(-1);
        }
        this.currentInstructionDuration = instruction.getDuration(this.currentInstructionProgress, this.getTheoreticalSpeed());
        this.timer = 0;
    }

    public boolean isIdle() {
        return this.currentInstruction == -1;
    }

    public void onRedstoneUpdate(boolean isPowered, boolean isRunning) {
        if (!this.poweredPreviously && isPowered) {
            this.risingFlank();
        }
        this.poweredPreviously = isPowered;
        if (!this.isIdle()) {
            return;
        }
        if (isPowered == isRunning) {
            return;
        }
        if (!this.level.hasNeighborSignal(this.worldPosition)) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.run(0);
    }

    public void risingFlank() {
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.poweredPreviously) {
            return;
        }
        this.poweredPreviously = true;
        if (Objects.requireNonNull(instruction.onRedstonePulse()) == OnIsPoweredResult.CONTINUE) {
            this.run(this.currentInstruction + 1);
        }
    }

    public void run(int instructionIndex) {
        Instruction instruction = this.getInstruction(instructionIndex);
        if (instruction == null || instruction.instruction == SequencerInstructions.END) {
            if (this.getModifier() != 0) {
                this.detachKinetics();
            }
            this.currentInstruction = -1;
            this.currentInstructionDuration = -1;
            this.currentInstructionProgress = 0.0f;
            this.sequenceContext = null;
            this.timer = 0;
            if (!this.level.hasNeighborSignal(this.worldPosition)) {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            } else {
                this.sendData();
            }
            return;
        }
        this.detachKinetics();
        this.currentInstructionDuration = instruction.getDuration(0.0f, this.getTheoreticalSpeed());
        this.currentInstruction = instructionIndex;
        this.currentInstructionProgress = 0.0f;
        this.sequenceContext = SequenceContext.fromGearshift(instruction.instruction, this.getTheoreticalSpeed() * (float)this.getModifier(), instruction.value);
        this.timer = 0;
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(instructionIndex + 1)), 3);
    }

    public Instruction getInstruction(int instructionIndex) {
        return instructionIndex >= 0 && instructionIndex < this.instructions.size() ? this.instructions.get(instructionIndex) : null;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("InstructionIndex", this.currentInstruction);
        view.putInt("InstructionDuration", this.currentInstructionDuration);
        view.putFloat("InstructionProgress", this.currentInstructionProgress);
        view.putInt("Timer", this.timer);
        view.putBoolean("PrevPowered", this.poweredPreviously);
        if (!this.instructions.isEmpty()) {
            ValueOutput.TypedOutputList list = view.list("Instructions", Instruction.CODEC);
            this.instructions.forEach(arg_0 -> ((ValueOutput.TypedOutputList)list).add(arg_0));
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.currentInstruction = view.getIntOr("InstructionIndex", 0);
        this.currentInstructionDuration = view.getIntOr("InstructionDuration", 0);
        this.currentInstructionProgress = view.getFloatOr("InstructionProgress", 0.0f);
        this.poweredPreviously = view.getBooleanOr("PrevPowered", false);
        this.timer = view.getIntOr("Timer", 0);
        view.list("Instructions", Instruction.CODEC).ifPresentOrElse(list -> {
            this.instructions = new Vector(5);
            list.forEach(this.instructions::add);
        }, () -> {
            this.instructions = Instruction.createDefault();
        });
        super.read(view, clientPacket);
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public float getRotationSpeedModifier(Direction face) {
        if (this.isVirtual()) {
            return 1.0f;
        }
        return !this.hasSource() || face == this.getSourceFacing() ? 1.0f : (float)this.getModifier();
    }

    public int getModifier() {
        if (this.currentInstruction >= this.instructions.size()) {
            return 0;
        }
        return this.isIdle() ? 0 : this.instructions.get(this.currentInstruction).getSpeedModifier();
    }

    public Vector<Instruction> getInstructions() {
        return this.instructions;
    }

    public record SequenceContext(SequencerInstructions instruction, double relativeValue) {
        public static Codec<SequenceContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SequencerInstructions.CODEC.fieldOf("Mode").forGetter(SequenceContext::instruction), (App)Codec.DOUBLE.fieldOf("Value").forGetter(SequenceContext::relativeValue)).apply((Applicative)instance, SequenceContext::new));

        public static SequenceContext fromGearshift(SequencerInstructions instruction, double kineticSpeed, int absoluteValue) {
            return instruction.needsPropagation() ? new SequenceContext(instruction, kineticSpeed == 0.0 ? 0.0 : (double)absoluteValue / kineticSpeed) : null;
        }

        public double getEffectiveValue(double speedAtTarget) {
            return Math.abs(this.relativeValue * speedAtTarget);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            NBTHelper.writeEnum(nbt, "Mode", this.instruction);
            nbt.putDouble("Value", this.relativeValue);
            return nbt;
        }

        public static SequenceContext fromNBT(CompoundTag nbt) {
            if (nbt.isEmpty()) {
                return null;
            }
            return new SequenceContext(NBTHelper.readEnum(nbt, "Mode", SequencerInstructions.class), nbt.getDoubleOr("Value", 0.0));
        }
    }
}

