/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.chute;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.logistics.chute.AbstractChuteBlock;
import com.zurrtum.create.content.logistics.chute.ChuteBlockEntity;
import com.zurrtum.create.content.logistics.chute.SmartChuteBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SmartChuteBlockEntity
extends ChuteBlockEntity {
    ServerFilteringBehaviour filtering;

    public SmartChuteBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SMART_CHUTE, pos, state);
    }

    @Override
    protected boolean canAcceptItem(ItemStack stack) {
        return super.canAcceptItem(stack) && this.canActivate() && this.filtering.test(stack);
    }

    @Override
    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    @Override
    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    @Override
    protected boolean canActivate() {
        BlockState blockState = this.getBlockState();
        return blockState.hasProperty((Property)SmartChuteBlock.POWERED) && (Boolean)blockState.getValue((Property)SmartChuteBlock.POWERED) == false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.filtering = new ServerFilteringBehaviour(this).showCountWhen(this::isExtracting).withCallback($ -> this.invVersionTracker.reset());
        behaviours.add(this.filtering);
        super.addBehaviours(behaviours);
    }

    private boolean isExtracting() {
        boolean up = this.getItemMotion() < 0.0f;
        BlockPos chutePos = this.worldPosition.relative(up ? Direction.UP : Direction.DOWN);
        BlockState blockState = this.level.getBlockState(chutePos);
        return !AbstractChuteBlock.isChute(blockState) && !blockState.canBeReplaced();
    }
}

