/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import com.zurrtum.create.content.logistics.depot.EntityLauncher;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorAwardPacket;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorElytraPacket;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class EjectorBlockEntity
extends KineticBlockEntity {
    ServerScrollValueBehaviour maxStackSize;
    public DepotBehaviour depotBehaviour;
    public EntityLauncher launcher = new EntityLauncher(1, 0);
    LerpedFloat lidProgress = LerpedFloat.linear().startWithValue(1.0);
    boolean powered = false;
    boolean launch;
    State state = State.RETRACTING;
    @Nullable
    public Pair<Vec3, BlockPos> earlyTarget;
    public float earlyTargetTime;
    int scanCooldown;
    ItemStack trackedItem;

    public EjectorBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.WEIGHTED_EJECTOR, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.depotBehaviour = new DepotBehaviour(this);
        behaviours.add(this.depotBehaviour);
        this.maxStackSize = new ServerScrollValueBehaviour(this).between(0, 64);
        behaviours.add(this.maxStackSize);
        this.depotBehaviour.maxStackSize = () -> this.maxStackSize.getValue();
        this.depotBehaviour.canAcceptItems = () -> this.state == State.CHARGED;
        this.depotBehaviour.canFunnelsPullFrom = side -> side != this.getFacing();
        this.depotBehaviour.enableMerging();
        this.depotBehaviour.addSubBehaviours(behaviours);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignal();
    }

    public void activate() {
        this.launch = true;
        this.nudgeEntities();
    }

    protected boolean cannotLaunch() {
        return this.state != State.CHARGED && (!this.level.isClientSide() || this.state != State.LAUNCHING);
    }

    public void activateDeferred() {
        boolean doLogic;
        if (this.cannotLaunch()) {
            return;
        }
        Direction facing = this.getFacing();
        List entities = this.level.getEntitiesOfClass(Entity.class, new AABB(this.worldPosition).inflate(-0.0625, 0.0, -0.0625));
        boolean bl = doLogic = !this.level.isClientSide() || this.isVirtual();
        if (doLogic) {
            this.launchItems();
        }
        for (Entity entity : entities) {
            boolean isPlayerEntity = entity instanceof Player;
            if (!entity.isAlive() || entity instanceof ItemEntity || entity instanceof PackageEntity || entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
            entity.setOnGround(false);
            if (isPlayerEntity != this.level.isClientSide()) continue;
            entity.setPos((double)((float)this.worldPosition.getX() + 0.5f), (double)(this.worldPosition.getY() + 1), (double)((float)this.worldPosition.getZ() + 0.5f));
            this.launcher.applyMotion(entity, facing);
            if (!isPlayerEntity) continue;
            Player playerEntity = (Player)entity;
            if (this.launcher.getHorizontalDistance() * this.launcher.getHorizontalDistance() + this.launcher.getVerticalDistance() * this.launcher.getVerticalDistance() >= 625) {
                AllClientHandle.INSTANCE.sendPacket(new EjectorAwardPacket(this.worldPosition));
            }
            if (playerEntity.getItemBySlot(EquipmentSlot.CHEST).getItem() != Items.ELYTRA) continue;
            playerEntity.setXRot(-35.0f);
            playerEntity.setYRot(facing.toYRot());
            playerEntity.setDeltaMovement(playerEntity.getDeltaMovement().scale(0.75));
            this.deployElytra(playerEntity);
            AllClientHandle.INSTANCE.sendPacket(new EjectorElytraPacket(this.worldPosition));
        }
        if (doLogic) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.state = State.LAUNCHING;
            if (!this.level.isClientSide()) {
                this.level.playSound(null, this.worldPosition, SoundEvents.WOODEN_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.35f, 1.0f);
                this.level.playSound(null, this.worldPosition, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.1f, 1.4f);
            }
        }
    }

    public void deployElytra(Player playerEntity) {
        EntityHack.setElytraFlying((Entity)playerEntity);
    }

    protected void launchItems() {
        ItemStack heldItemStack = this.depotBehaviour.getHeldItemStack();
        Direction funnelFacing = this.getFacing().getOpposite();
        if (AbstractFunnelBlock.getFunnelFacing(this.level.getBlockState(this.worldPosition.above())) == funnelFacing) {
            ItemStack remainder;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (this.depotBehaviour.heldItem != null && (remainder = directOutput.tryExportingToBeltFunnel(heldItemStack, funnelFacing, false)) != null) {
                if (remainder.isEmpty()) {
                    this.depotBehaviour.removeHeldItem();
                } else if (remainder.getCount() != heldItemStack.getCount()) {
                    this.depotBehaviour.heldItem.stack = remainder;
                }
            }
            Iterator<TransportedItemStack> iterator = this.depotBehaviour.incoming.iterator();
            while (iterator.hasNext()) {
                TransportedItemStack transportedItemStack = iterator.next();
                ItemStack stack = transportedItemStack.stack;
                ItemStack remainder2 = directOutput.tryExportingToBeltFunnel(stack, funnelFacing, false);
                if (remainder2 == null) continue;
                if (remainder2.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                if (ItemStack.isSameItem((ItemStack)remainder2, (ItemStack)stack)) continue;
                transportedItemStack.stack = remainder2;
            }
            boolean change = false;
            DepotBehaviour.DepotOutputHandler outputs = this.depotBehaviour.processingOutputBuffer;
            int size = outputs.getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack remainder3 = directOutput.tryExportingToBeltFunnel(outputs.getItem(i), funnelFacing, false);
                if (remainder3 == null) continue;
                outputs.setItem(i, remainder3);
                change = true;
            }
            if (change) {
                outputs.setChanged();
            }
            return;
        }
        if (!this.level.isClientSide()) {
            for (Direction d : Iterate.directions) {
                BlockState blockState = this.level.getBlockState(this.worldPosition.relative(d));
                if (!(blockState.getBlock() instanceof ObserverBlock) || blockState.getValue((Property)ObserverBlock.FACING) != d.getOpposite()) continue;
                blockState.updateShape((LevelReader)this.level, (ScheduledTickAccess)this.level, this.worldPosition.relative(d), d.getOpposite(), this.worldPosition, blockState, this.level.random);
            }
        }
        if (this.depotBehaviour.heldItem != null) {
            this.addToLaunchedItems(heldItemStack);
            this.depotBehaviour.removeHeldItem();
        }
        for (TransportedItemStack transportedItemStack : this.depotBehaviour.incoming) {
            this.addToLaunchedItems(transportedItemStack.stack);
        }
        this.depotBehaviour.incoming.clear();
        boolean change = false;
        DepotBehaviour.DepotOutputHandler outputs = this.depotBehaviour.processingOutputBuffer;
        int size = outputs.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = outputs.getItem(i);
            if (stack.isEmpty()) continue;
            this.addToLaunchedItems(stack);
            outputs.setItem(i, ItemStack.EMPTY);
            change = true;
        }
        if (change) {
            outputs.setChanged();
        }
    }

    protected void addToLaunchedItems(ItemStack stack) {
        if ((!this.level.isClientSide() || this.isVirtual()) && this.trackedItem == null && this.scanCooldown == 0) {
            this.scanCooldown = (Integer)AllConfigs.server().kinetics.ejectorScanInterval.get();
            this.trackedItem = stack;
        }
        EjectorItemEntity item = new EjectorItemEntity(this.level, this, stack);
        this.level.addFreshEntity((Entity)item);
    }

    public Direction getFacing() {
        BlockState blockState = this.getBlockState();
        if (!blockState.is((Block)AllBlocks.WEIGHTED_EJECTOR)) {
            return Direction.UP;
        }
        Direction facing = (Direction)blockState.getValue((Property)EjectorBlock.HORIZONTAL_FACING);
        return facing;
    }

    @Override
    public void tick() {
        super.tick();
        boolean doLogic = !this.level.isClientSide() || this.isVirtual();
        State prevState = this.state;
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.launch) {
            this.launch = false;
            this.activateDeferred();
        }
        if (this.state == State.LAUNCHING) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.lidProgress.tickChaser();
            if (this.lidProgress.getValue() > 0.9375f && doLogic) {
                this.state = State.RETRACTING;
                this.lidProgress.setValue(1.0);
            }
        }
        if (this.state == State.CHARGED) {
            this.lidProgress.setValue(0.0);
            this.lidProgress.updateChaseSpeed(0.0);
            if (doLogic) {
                this.ejectIfTriggered();
            }
        }
        if (this.state == State.RETRACTING) {
            if (this.lidProgress.getChaseTarget() == 1.0f && !this.lidProgress.settled()) {
                this.lidProgress.tickChaser();
            } else {
                this.lidProgress.updateChaseTarget(0.0f);
                this.lidProgress.updateChaseSpeed(0.0);
                if (this.lidProgress.getValue() == 0.0f && doLogic) {
                    this.state = State.CHARGED;
                    this.lidProgress.setValue(0.0);
                    this.sendData();
                }
                float value = Mth.clamp((float)(this.lidProgress.getValue() - this.getWindUpSpeed()), (float)0.0f, (float)1.0f);
                this.lidProgress.setValue(value);
                int soundRate = (int)(1.0f / (this.getWindUpSpeed() * 5.0f)) + 1;
                float volume = 0.125f;
                float pitch = 1.5f - this.lidProgress.getValue();
                if ((int)this.level.getGameTime() % soundRate == 0 && doLogic) {
                    this.level.playSound(null, this.worldPosition, SoundEvents.WOODEN_BUTTON_CLICK_OFF, SoundSource.BLOCKS, volume, pitch);
                }
            }
        }
        if (this.state != prevState) {
            this.notifyUpdate();
        }
    }

    private boolean scanTrajectoryForObstacles(int time) {
        BlockState blockState;
        boolean miss;
        Vec3 target;
        if (time <= 2) {
            return false;
        }
        Vec3 source = this.getLaunchedItemLocation(time);
        BlockHitResult rayTraceBlocks = this.level.clip(new ClipContext(source, target = this.getLaunchedItemLocation(time + 1), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
        boolean bl = miss = rayTraceBlocks.getType() == HitResult.Type.MISS;
        if (!miss && rayTraceBlocks.getType() == HitResult.Type.BLOCK && FunnelBlock.isFunnel(blockState = this.level.getBlockState(rayTraceBlocks.getBlockPos())) && blockState.hasProperty((Property)FunnelBlock.EXTRACTING) && ((Boolean)blockState.getValue((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            miss = true;
        }
        if (miss) {
            if (this.earlyTarget != null && this.earlyTargetTime < (float)(time + 1)) {
                this.earlyTarget = null;
                this.earlyTargetTime = 0.0f;
            }
            return false;
        }
        Vec3 vec = rayTraceBlocks.getLocation();
        this.earlyTarget = Pair.of(vec.add(Vec3.atLowerCornerOf((Vec3i)rayTraceBlocks.getDirection().getUnitVec3i()).scale(0.25)), rayTraceBlocks.getBlockPos());
        this.earlyTargetTime = (float)((double)time + source.distanceTo(vec) / source.distanceTo(target));
        this.sendData();
        return true;
    }

    protected void nudgeEntities() {
        for (Entity entity : this.level.getEntitiesOfClass(Entity.class, new AABB(this.worldPosition).inflate(-0.0625, 0.0, -0.0625))) {
            if (!entity.isAlive() || entity.getPistonPushReaction() == PushReaction.IGNORE || entity instanceof Player) continue;
            entity.setPos(entity.getX(), entity.getY() + 0.125, entity.getZ());
        }
    }

    protected void ejectIfTriggered() {
        DirectBeltInputBehaviour targetOpenInv;
        if (this.powered) {
            return;
        }
        int presentStackSize = this.depotBehaviour.getPresentStackSize();
        if (presentStackSize == 0) {
            return;
        }
        if (presentStackSize < this.maxStackSize.getValue()) {
            return;
        }
        if (this.depotBehaviour.heldItem != null && this.depotBehaviour.heldItem.beltPosition < 0.49f) {
            return;
        }
        Direction funnelFacing = this.getFacing().getOpposite();
        ItemStack held = this.depotBehaviour.getHeldItemStack();
        if (AbstractFunnelBlock.getFunnelFacing(this.level.getBlockState(this.worldPosition.above())) == funnelFacing) {
            ItemStack tryFunnel;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (!(this.depotBehaviour.heldItem == null || (tryFunnel = directOutput.tryExportingToBeltFunnel(held, funnelFacing, true)) != null && tryFunnel.isEmpty())) {
                return;
            }
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null && this.depotBehaviour.heldItem != null && targetOpenInv.handleInsertion(held, Direction.UP, true).getCount() == held.getCount()) {
            return;
        }
        this.activate();
        this.notifyUpdate();
    }

    public DirectBeltInputBehaviour getTargetOpenInv() {
        BlockPos targetPos = this.earlyTarget != null ? this.earlyTarget.getSecond() : this.worldPosition.above(this.launcher.getVerticalDistance()).relative(this.getFacing(), Math.max(1, this.launcher.getHorizontalDistance()));
        return BlockEntityBehaviour.get((BlockGetter)this.level, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public Vec3 getLaunchedItemLocation(float time) {
        return this.launcher.getGlobalPos((double)time, this.getFacing().getOpposite(), this.worldPosition);
    }

    public Vec3 getLaunchedItemMotion(float time) {
        Vec3 pos = this.launcher.getGlobalVelocity(time, this.getFacing().getOpposite()).scale(0.5);
        return new Vec3((double)((int)(Mth.clamp((double)pos.x, (double)-3.9, (double)3.9) * 8000.0)) / 8000.0, (double)((int)(Mth.clamp((double)pos.y, (double)-3.9, (double)3.9) * 8000.0)) / 8000.0, (double)((int)(Mth.clamp((double)pos.z, (double)-3.9, (double)3.9) * 8000.0)) / 8000.0);
    }

    public float getWindUpSpeed() {
        int hd = this.launcher.getHorizontalDistance();
        int vd = this.launcher.getVerticalDistance();
        float speedFactor = Math.abs(this.getSpeed()) / 256.0f;
        float distanceFactor = hd == 0 && vd == 0 ? 1.0f : 1.0f * Mth.sqrt((float)(hd * hd + vd * vd));
        return speedFactor / distanceFactor;
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putInt("HorizontalDistance", this.launcher.getHorizontalDistance());
        view.putInt("VerticalDistance", this.launcher.getVerticalDistance());
        view.putBoolean("Powered", this.powered);
        view.store("State", State.CODEC, (Object)this.state);
        this.lidProgress.write(view.child("Lid"));
        if (this.earlyTarget != null) {
            view.store("EarlyTarget", Vec3.CODEC, (Object)this.earlyTarget.getFirst());
            view.store("EarlyTargetPos", BlockPos.CODEC, (Object)this.earlyTarget.getSecond());
            view.putFloat("EarlyTargetTime", this.earlyTargetTime);
        }
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        view.putInt("HorizontalDistance", this.launcher.getHorizontalDistance());
        view.putInt("VerticalDistance", this.launcher.getVerticalDistance());
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        int horizontalDistance = view.getIntOr("HorizontalDistance", 0);
        int verticalDistance = view.getIntOr("VerticalDistance", 0);
        if (this.launcher.getHorizontalDistance() != horizontalDistance || this.launcher.getVerticalDistance() != verticalDistance) {
            this.launcher.set(horizontalDistance, verticalDistance);
            this.launcher.clamp((Integer)AllConfigs.server().kinetics.maxEjectorDistance.get());
        }
        this.powered = view.getBooleanOr("Powered", false);
        this.state = view.read("State", State.CODEC).orElse(State.RETRACTING);
        this.lidProgress.read(view.childOrEmpty("Lid"), false);
        this.earlyTarget = null;
        this.earlyTargetTime = 0.0f;
        view.read("EarlyTarget", Vec3.CODEC).ifPresent(vec3d -> {
            this.earlyTarget = Pair.of(vec3d, (BlockPos)view.read("EarlyTargetPos", BlockPos.CODEC).orElseThrow());
            this.earlyTargetTime = view.getFloatOr("EarlyTargetTime", 0.0f);
        });
        float forceAngle = view.getFloatOr("ForceAngle", -1.0f);
        if (forceAngle != -1.0f) {
            this.lidProgress.startWithValue(forceAngle);
        }
    }

    public void updateSignal() {
        boolean shoudPower = this.level.hasNeighborSignal(this.worldPosition);
        if (shoudPower == this.powered) {
            return;
        }
        this.powered = shoudPower;
        this.sendData();
    }

    public void setTarget(int horizontalDistance, int verticalDistance) {
        this.launcher.set(Math.max(1, horizontalDistance), verticalDistance);
        this.sendData();
    }

    public BlockPos getTargetPosition() {
        BlockState blockState = this.getBlockState();
        if (!blockState.is((Block)AllBlocks.WEIGHTED_EJECTOR)) {
            return this.worldPosition;
        }
        Direction facing = (Direction)blockState.getValue((Property)EjectorBlock.HORIZONTAL_FACING);
        return this.worldPosition.relative(facing, this.launcher.getHorizontalDistance()).above(this.launcher.getVerticalDistance());
    }

    public float getLidProgress(float pt) {
        return this.lidProgress.getValue(pt);
    }

    public State getState() {
        return this.state;
    }

    public static enum State implements StringRepresentable
    {
        CHARGED,
        LAUNCHING,
        RETRACTING;

        public static final Codec<State> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(State::values);
        }
    }

    private static abstract class EntityHack
    extends Entity {
        public EntityHack(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
            super(p_i48580_1_, p_i48580_2_);
        }

        public static void setElytraFlying(Entity e) {
            SynchedEntityData data = e.getEntityData();
            data.set(DATA_SHARED_FLAGS_ID, (Object)((byte)((Byte)data.get(DATA_SHARED_FLAGS_ID) | 0x80)));
        }
    }
}

