/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.stockTicker;

import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsManager;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class StockCheckingBlockEntity
extends SmartBlockEntity {
    public LogisticallyLinkedBehaviour behaviour;

    public StockCheckingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.behaviour = new LogisticallyLinkedBehaviour(this, false);
        behaviours.add(this.behaviour);
    }

    public InventorySummary getRecentSummary() {
        return LogisticsManager.getSummaryOfNetwork(this.behaviour.freqId, false);
    }

    public InventorySummary getAccurateSummary() {
        return LogisticsManager.getSummaryOfNetwork(this.behaviour.freqId, true);
    }

    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, PackageOrder order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        return this.broadcastPackageRequest(type, PackageOrderWithCrafts.simple(order.stacks()), ignoredHandler, address);
    }

    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, PackageOrderWithCrafts order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        return LogisticsManager.broadcastPackageRequest(this.behaviour.freqId, type, order, ignoredHandler, address);
    }
}

