/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.stockTicker;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StockTickerBlock
extends HorizontalDirectionalBlock
implements IBE<StockTickerBlockEntity>,
IWrenchable,
ItemInventoryProvider<StockTickerBlockEntity> {
    public static final MapCodec<StockTickerBlock> CODEC = StockTickerBlock.simpleCodec(StockTickerBlock::new);

    public StockTickerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, StockTickerBlockEntity blockEntity, Direction context) {
        return blockEntity.receivedPayments;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        boolean reverse = pContext.getPlayer() != null && pContext.getPlayer().isShiftKeyDown();
        return (BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)(reverse ? facing.getOpposite() : facing));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING}));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof LogisticallyLinkedBlockItem) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, stbe -> {
            if (!stbe.behaviour.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            if (!level.isClientSide()) {
                StockTickerBlockEntity.StockTickerInventory inventory = stbe.receivedPayments;
                Inventory playerInventory = player.getInventory();
                boolean anySuccess = false;
                int size = inventory.getContainerSize();
                for (int i = 0; i < size; ++i) {
                    ItemStack target = inventory.getItem(i);
                    if (target.isEmpty()) continue;
                    inventory.setItem(i, ItemStack.EMPTY);
                    playerInventory.placeItemBackInInventory(target);
                    anySuccess = true;
                }
                if (anySuccess) {
                    inventory.setChanged();
                    player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + player.level().random.nextFloat());
                    return InteractionResult.SUCCESS;
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (stbe.isKeeperPresent()) {
                    MenuProvider.openHandledScreen(sp, stbe::createCategoryMenu);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"create.stock_ticker.keeper_missing"), true);
                }
            }
            return InteractionResult.SUCCESS;
        });
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.STOCK_TICKER;
    }

    @Override
    public Class<StockTickerBlockEntity> getBlockEntityClass() {
        return StockTickerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends StockTickerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.STOCK_TICKER;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

