/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.stockTicker;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperCategoryMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StockTickerBlockEntity
extends StockCheckingBlockEntity {
    public static final Codec<Map<UUID, List<Integer>>> UUID_MAP_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.INT.listOf());
    public List<List<BigItemStack>> lastClientsideStockSnapshot;
    protected InventorySummary lastClientsideStockSnapshotAsSummary;
    protected List<BigItemStack> newlyReceivedStockSnapshot;
    public String previouslyUsedAddress = "";
    public int activeLinks;
    public int ticksSinceLastUpdate;
    public List<ItemStack> categories;
    public Map<UUID, List<Integer>> hiddenCategoriesByPlayer;
    public StockTickerInventory receivedPayments = new StockTickerInventory();

    public StockTickerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.STOCK_TICKER, pos, state);
        this.categories = new ArrayList<ItemStack>();
        this.hiddenCategoriesByPlayer = new HashMap<UUID, List<Integer>>();
    }

    public void resetTicksSinceLastUpdate() {
        this.ticksSinceLastUpdate = 0;
    }

    public Container getReceivedPaymentsHandler() {
        return this.receivedPayments;
    }

    public List<List<BigItemStack>> getClientStockSnapshot() {
        return this.lastClientsideStockSnapshot;
    }

    public InventorySummary getLastClientsideStockSnapshotAsSummary() {
        return this.lastClientsideStockSnapshotAsSummary;
    }

    public int getTicksSinceLastUpdate() {
        return this.ticksSinceLastUpdate;
    }

    @Override
    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, PackageOrderWithCrafts order, IdentifiedInventory ignoredHandler, String address) {
        boolean result = super.broadcastPackageRequest(type, order, ignoredHandler, address);
        this.previouslyUsedAddress = address;
        this.notifyUpdate();
        return result;
    }

    @Override
    public InventorySummary getRecentSummary() {
        InventorySummary recentSummary = super.getRecentSummary();
        int contributingLinks = recentSummary.contributingLinks;
        if (this.activeLinks != contributingLinks && !this.isRemoved()) {
            this.activeLinks = contributingLinks;
            this.sendData();
        }
        return recentSummary;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide() && this.ticksSinceLastUpdate < 100) {
            ++this.ticksSinceLastUpdate;
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putString("PreviousAddress", this.previouslyUsedAddress);
        this.receivedPayments.write(view);
        view.store("Categories", CreateCodecs.ITEM_LIST_CODEC, this.categories);
        view.store("HiddenCategories", UUID_MAP_CODEC, this.hiddenCategoriesByPlayer);
        if (clientPacket) {
            view.putInt("ActiveLinks", this.activeLinks);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.previouslyUsedAddress = view.getStringOr("PreviousAddress", "");
        this.receivedPayments.read(view);
        this.categories.clear();
        view.read("Categories", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> list.forEach(stack -> {
            if (!stack.isEmpty() && !(stack.getItem() instanceof FilterItem)) {
                return;
            }
            this.categories.add((ItemStack)stack);
        }));
        this.hiddenCategoriesByPlayer.clear();
        view.read("HiddenCategories", UUID_MAP_CODEC).ifPresent(map -> this.hiddenCategoriesByPlayer.putAll((Map<UUID, List<Integer>>)map));
        if (clientPacket) {
            this.activeLinks = view.getIntOr("ActiveLinks", 0);
        }
    }

    public void receiveStockPacket(List<BigItemStack> stacks, boolean endOfTransmission) {
        if (this.newlyReceivedStockSnapshot == null) {
            this.newlyReceivedStockSnapshot = new ArrayList<BigItemStack>();
        }
        this.newlyReceivedStockSnapshot.addAll(stacks);
        if (!endOfTransmission) {
            return;
        }
        this.lastClientsideStockSnapshotAsSummary = new InventorySummary();
        this.lastClientsideStockSnapshot = new ArrayList<List<BigItemStack>>();
        for (BigItemStack bigStack : this.newlyReceivedStockSnapshot) {
            this.lastClientsideStockSnapshotAsSummary.add(bigStack);
        }
        for (ItemStack filter : this.categories) {
            ArrayList<BigItemStack> inCategory = new ArrayList<BigItemStack>();
            if (!filter.isEmpty()) {
                FilterItemStack filterItemStack = FilterItemStack.of(filter);
                Iterator<BigItemStack> iterator = this.newlyReceivedStockSnapshot.iterator();
                while (iterator.hasNext()) {
                    BigItemStack bigStack = iterator.next();
                    if (!filterItemStack.test(this.level, bigStack.stack)) continue;
                    inCategory.add(bigStack);
                    iterator.remove();
                }
            }
            this.lastClientsideStockSnapshot.add(inCategory);
        }
        ArrayList<BigItemStack> unsorted = new ArrayList<BigItemStack>(this.newlyReceivedStockSnapshot);
        this.lastClientsideStockSnapshot.add(unsorted);
        this.newlyReceivedStockSnapshot = null;
    }

    public boolean isKeeperPresent() {
        for (int yOffset : Iterate.zeroAndOne) {
            for (Direction side : Iterate.horizontalDirections) {
                BlockEntity entity;
                BlockPos seatPos = this.worldPosition.below(yOffset).relative(side);
                for (SeatEntity seatEntity : this.level.getEntitiesOfClass(SeatEntity.class, new AABB(seatPos))) {
                    if (!seatEntity.isVehicle()) continue;
                    return true;
                }
                if (yOffset != 0 || (entity = this.level.getBlockEntity(seatPos)) == null || entity.getType() != AllBlockEntityTypes.HEATER) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void destroy() {
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)this.receivedPayments);
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        for (ItemStack filter : this.categories) {
            if (filter.isEmpty() || !(filter.getItem() instanceof FilterItem)) continue;
            Containers.dropItemStack((Level)this.level, (double)x, (double)y, (double)z, (ItemStack)filter);
        }
        super.destroy();
    }

    public void playEffect() {
        AllSoundEvents.STOCK_LINK.playAt(this.level, (Vec3i)this.worldPosition, 1.0f, 1.0f, false);
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)this.worldPosition);
        this.level.addParticle((ParticleOptions)AllParticleTypes.WIFI, vec3.x, vec3.y, vec3.z, 1.0, 1.0, 1.0);
    }

    public StockKeeperCategoryMenu createCategoryMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer, RegistryFriendlyByteBuf extraData) {
        extraData.writeBlockPos(this.worldPosition);
        return new StockKeeperCategoryMenu(pContainerId, pPlayerInventory, this);
    }

    public StockKeeperRequestMenu createRequestMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer, RegistryFriendlyByteBuf extraData) {
        boolean showLockOption = this.behaviour.mayAdministrate(pPlayer) && Create.LOGISTICS.isLockable(this.behaviour.freqId);
        boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(this.behaviour.freqId);
        extraData.writeBlockPos(this.worldPosition);
        extraData.writeBoolean(showLockOption);
        extraData.writeBoolean(isCurrentlyLocked);
        return new StockKeeperRequestMenu(pContainerId, pPlayerInventory, this);
    }

    public class StockTickerInventory
    extends ItemStackHandler {
        public StockTickerInventory() {
            super(27);
        }

        @Override
        public void setChanged() {
            StockTickerBlockEntity.this.notifyUpdate();
        }
    }
}

