/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tunnel;

import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class BrassTunnelItemHandler
implements ItemInventory {
    private final BrassTunnelBlockEntity blockEntity;

    public BrassTunnelItemHandler(BrassTunnelBlockEntity be) {
        this.blockEntity = be;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (this.blockEntity.hasDistributionBehaviour()) {
            return this.blockEntity.canTakeItems();
        }
        Container inventory = this.blockEntity.getBeltCapability();
        if (inventory == null) {
            return false;
        }
        return inventory.canPlaceItem(slot, stack);
    }

    public int getContainerSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.blockEntity.stackToDistribute.isEmpty() ? 64 : this.blockEntity.stackToDistribute.getMaxStackSize();
    }

    public ItemStack getItem(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        if (this.blockEntity.hasDistributionBehaviour()) {
            return this.blockEntity.stackToDistribute;
        }
        Container inventory = this.blockEntity.getBeltCapability();
        if (inventory == null) {
            return ItemStack.EMPTY;
        }
        return inventory.getItem(0);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        if (this.blockEntity.hasDistributionBehaviour()) {
            this.blockEntity.setStackToDistribute(stack, null);
        } else {
            Container inventory = this.blockEntity.getBeltCapability();
            if (inventory == null) {
                return;
            }
            inventory.setItem(0, stack);
        }
    }
}

