/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.fluids.transfer.GenericItemFilling;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasinBlock
extends Block
implements IBE<BasinBlockEntity>,
IWrenchable,
ItemInventoryProvider<BasinBlockEntity>,
FluidInventoryProvider<BasinBlockEntity> {
    public static final EnumProperty<Direction> FACING = EnumProperty.create((String)"facing", Direction.class, side -> side != Direction.UP);

    public BasinBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.DOWN));
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, BasinBlockEntity blockEntity, Direction context) {
        return blockEntity.itemCapability;
    }

    @Override
    public FluidInventory getFluidInventory(LevelAccessor world, BlockPos pos, BlockState state, BasinBlockEntity blockEntity, Direction context) {
        return blockEntity.fluidCapability;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.createBlockStateDefinition(p_206840_1_.add(new Property[]{FACING}));
    }

    public static boolean isBasin(LevelReader world, BlockPos pos) {
        return world.getBlockEntity(pos) instanceof BasinBlockEntity;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return !(world.getBlockEntity(pos.above()) instanceof BasinOperatingBlockEntity);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (!context.getLevel().isClientSide()) {
            this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), bte -> bte.onWrenched(context.getClickedFace()));
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> {
            if (!stack.isEmpty()) {
                BasinBlockEntity.BasinFluidHandler fluidHandler;
                if (FluidHelper.tryEmptyItemIntoBE(level, player, hand, stack, be)) {
                    return InteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE(level, player, hand, stack, be)) {
                    return InteractionResult.SUCCESS;
                }
                if (GenericItemEmptying.canItemBeEmptied(level, stack) || GenericItemFilling.canItemBeFilled(level, stack)) {
                    return InteractionResult.SUCCESS;
                }
                if (stack.getItem().equals(Items.SPONGE) && (fluidHandler = be.fluidCapability) != null) {
                    boolean drained = false;
                    int size = fluidHandler.size();
                    for (int i = 0; i < size; ++i) {
                        if (fluidHandler.getStack(i).isEmpty()) continue;
                        fluidHandler.setStack(i, FluidStack.EMPTY);
                        drained = true;
                    }
                    if (drained) {
                        fluidHandler.markDirty();
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            ItemInventory inv = be.itemCapability;
            if (inv == null) {
                inv = new ItemStackHandler(1);
            }
            boolean success = false;
            int size = inv.getContainerSize();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stackInSlot = inv.getItem(slot);
                if (stackInSlot.isEmpty()) continue;
                player.getInventory().placeItemBackInInventory(stackInSlot);
                inv.setItem(slot, ItemStack.EMPTY);
                success = true;
            }
            if (success) {
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + level.getRandom().nextFloat());
            }
            be.onEmptied();
            return InteractionResult.SUCCESS;
        });
    }

    public void updateEntityMovementAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityMovementAfterFallOn(worldIn, entityIn);
        if (!worldIn.getBlockState(entityIn.blockPosition()).is((Block)this)) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.isAlive()) {
            return;
        }
        this.withBlockEntityDo(worldIn, entityIn.blockPosition(), be -> {
            ItemStack stack = itemEntity.getItem();
            int count = stack.getCount();
            int insert = be.itemCapability.insert(stack);
            if (insert == count) {
                itemEntity.discard();
            } else if (insert != 0) {
                stack.shrink(insert);
                itemEntity.setItem(stack);
            }
        });
    }

    public VoxelShape getInteractionShape(BlockState p_199600_1_, BlockGetter p_199600_2_, BlockPos p_199600_3_) {
        return AllShapes.BASIN_RAYTRACE_SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.BASIN_BLOCK_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        EntityCollisionContext entityShapeContext;
        if (ctx instanceof EntityCollisionContext && (entityShapeContext = (EntityCollisionContext)ctx).getEntity() instanceof ItemEntity) {
            return AllShapes.BASIN_COLLISION_SHAPE;
        }
        return this.getShape(state, reader, pos, ctx);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos, Direction direction) {
        Optional getter = this.getBlockEntityOptional((BlockGetter)worldIn, pos);
        if (getter.isEmpty()) {
            return 0;
        }
        BasinInventory inv = ((BasinBlockEntity)getter.get()).itemCapability;
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 9; ++j) {
            int slotLimit = inv.getMaxStackSize();
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(slotLimit, (Integer)itemstack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64));
            ++i;
        }
        return Mth.floor((float)(f / 9.0f * 14.0f)) + (i > 0 ? 1 : 0);
    }

    @Override
    public Class<BasinBlockEntity> getBlockEntityClass() {
        return BasinBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends BasinBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.BASIN;
    }

    public static boolean canOutputTo(BlockGetter world, BlockPos basinPos, Direction direction) {
        DirectBeltInputBehaviour directBeltInputBehaviour;
        BlockPos neighbour = basinPos.relative(direction);
        BlockPos output = neighbour.below();
        BlockState blockState = world.getBlockState(neighbour);
        if (FunnelBlock.isFunnel(blockState)) {
            if (FunnelBlock.getFunnelFacing(blockState) == direction) {
                return false;
            }
        } else {
            if (!blockState.getCollisionShape(world, neighbour).isEmpty()) {
                return false;
            }
            BlockEntity blockEntity = world.getBlockEntity(output);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                return belt.getSpeed() == 0.0f || belt.getMovementFacing() != direction.getOpposite();
            }
        }
        if ((directBeltInputBehaviour = BlockEntityBehaviour.get(world, output, DirectBeltInputBehaviour.TYPE)) != null) {
            return directBeltInputBehaviour.canInsertFromSide(direction);
        }
        return false;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

