/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class BasinInventory
implements ItemInventory {
    private final BasinBlockEntity blockEntity;
    private final NonNullList<ItemStack> stacks = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
    private boolean check = true;

    public BasinInventory(BasinBlockEntity be) {
        this.blockEntity = be;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (this.check) {
            if (slot > 9) {
                return false;
            }
            for (int i = 0; i < slot; ++i) {
                ItemStack itemStack = (ItemStack)this.stacks.get(i);
                if (!itemStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack)) continue;
                return false;
            }
        }
        return true;
    }

    public void disableCheck() {
        this.check = false;
    }

    public void enableCheck() {
        this.check = true;
    }

    public int getContainerSize() {
        return 18;
    }

    public ItemStack getItem(int slot) {
        if (slot >= 18) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 18) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
    }

    @Override
    public void setChanged() {
        this.blockEntity.notifyChangeOfContents();
        this.blockEntity.notifyUpdate();
    }

    public void write(ValueOutput view) {
        ValueOutput inventory = view.child("Inventory");
        ValueOutput.TypedOutputList input = inventory.list("Input", ItemStack.CODEC);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            input.add((Object)stack);
        }
        ValueOutput.TypedOutputList output = inventory.list("Output", ItemStack.CODEC);
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            output.add((Object)stack);
        }
    }

    public void read(ValueInput view) {
        view.child("Inventory").ifPresentOrElse(inventory -> {
            int i;
            List list = inventory.listOrEmpty("Input", ItemStack.CODEC).stream().toList();
            int stop = list.size();
            for (i = 0; i < stop; ++i) {
                this.stacks.set(i, (Object)((ItemStack)list.get(i)));
            }
            for (i = stop; i < 9; ++i) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
            }
            list = inventory.listOrEmpty("Output", ItemStack.CODEC).stream().toList();
            stop = 9 + list.size();
            for (i = 9; i < stop; ++i) {
                this.stacks.set(i, (Object)((ItemStack)list.get(i - 9)));
            }
            for (i = stop; i < 18; ++i) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
            }
        }, () -> this.stacks.clear());
    }
}

