/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.burner;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlazeBurnerBlockEntity
extends SmartBlockEntity {
    public static final int MAX_HEAT_CAPACITY = 10000;
    public static final int INSERTION_THRESHOLD = 500;
    public LerpedFloat headAnimation;
    public boolean stockKeeper = false;
    public boolean isCreative = false;
    public boolean goggles = false;
    public boolean hat;
    protected FuelType activeFuel = FuelType.NONE;
    protected int remainingBurnTime = 0;
    public LerpedFloat headAngle;

    public BlazeBurnerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.HEATER, pos, state);
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((AngleHelper.horizontalAngle((Direction)state.getValueOrElse((Property)BlazeBurnerBlock.FACING, (Comparable)Direction.SOUTH)) + 180.0f) % 360.0f);
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            AllClientHandle.INSTANCE.tickBlazeBurnerAnimation(this);
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            }
            return;
        }
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.stockKeeper = BlazeBurnerBlockEntity.getStockTicker((LevelAccessor)this.level, this.worldPosition) != null;
    }

    @Nullable
    public static StockTickerBlockEntity getStockTicker(LevelAccessor level, BlockPos pos) {
        for (Direction direction : Iterate.horizontalDirections) {
            BlockEntity blockEntity;
            Level l;
            if (level instanceof Level && !(l = (Level)level).isLoaded(pos)) {
                return null;
            }
            BlockState blockState = level.getBlockState(pos.relative(direction));
            if (!blockState.is((Block)AllBlocks.STOCK_TICKER) || !((blockEntity = level.getBlockEntity(pos.relative(direction))) instanceof StockTickerBlockEntity)) continue;
            StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
            return stbe;
        }
        return null;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        if (!this.isCreative) {
            view.putInt("fuelLevel", this.activeFuel.ordinal());
            view.putInt("burnTimeRemaining", this.remainingBurnTime);
        } else {
            view.putBoolean("isCreative", true);
        }
        if (this.goggles) {
            view.putBoolean("Goggles", true);
        }
        if (this.hat) {
            view.putBoolean("TrainHat", true);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.activeFuel = FuelType.values()[view.getIntOr("fuelLevel", 0)];
        this.remainingBurnTime = view.getIntOr("burnTimeRemaining", 0);
        this.isCreative = view.getBooleanOr("isCreative", false);
        this.goggles = view.getBooleanOr("Goggles", false);
        this.hat = view.getBooleanOr("TrainHat", false);
        super.read(view, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf(this.getBlockState());
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelForRender() {
        BlazeBurnerBlock.HeatLevel heatLevel = this.getHeatLevelFromBlock();
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.stockKeeper) {
            return BlazeBurnerBlock.HeatLevel.FADING;
        }
        return heatLevel;
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)heat)));
        this.notifyUpdate();
    }

    protected boolean tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (itemStack.getItemHolder().is(AllItemTags.BLAZE_BURNER_FUEL_SPECIAL)) {
            newBurnTime = 3200;
            newFuel = FuelType.SPECIAL;
        } else {
            newBurnTime = this.level.fuelValues().burnDuration(itemStack);
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (itemStack.getItemHolder().is(AllItemTags.BLAZE_BURNER_FUEL_REGULAR)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime <= 500) {
                newBurnTime += this.remainingBurnTime;
            } else if (forceOverflow && newFuel == FuelType.NORMAL) {
                newBurnTime = this.remainingBurnTime < 10000 ? Math.min(this.remainingBurnTime + newBurnTime, 10000) : this.remainingBurnTime;
            } else {
                return false;
            }
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.level.isClientSide()) {
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
            return true;
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.level.playSound(null, this.worldPosition, SoundEvents.BLAZE_AMBIENT, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 1.15f - this.level.random.nextFloat() * 0.25f);
        }
        return true;
    }

    protected void applyCreativeFuel() {
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.getHeatLevelFromBlock().nextActiveLevel();
        if (this.level.isClientSide()) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setBlockHeat(next);
    }

    public boolean isCreativeFuel(ItemStack stack) {
        return stack.is(AllItems.CREATIVE_BLAZE_CAKE);
    }

    public boolean isValidBlockAbove() {
        if (this.isVirtual()) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(this.worldPosition.above());
        return BasinBlock.isBasin((LevelReader)this.level, this.worldPosition.above()) || blockState.getBlock() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.level.playSound(null, this.worldPosition, SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 0.125f + this.level.random.nextFloat() * 0.125f, 0.75f - this.level.random.nextFloat() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel.ordinal()) {
            case 2: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case 1: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.level == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource r = this.level.getRandom();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        Vec3 v = c.add(VecHelper.offsetRandomly(Vec3.ZERO, r, 0.125f).multiply(1.0, 0.0, 1.0));
        if (r.nextInt(4) != 0) {
            return;
        }
        boolean empty = this.level.getBlockState(this.worldPosition.above()).getCollisionShape((BlockGetter)this.level, this.worldPosition.above()).isEmpty();
        if (empty || r.nextInt(8) == 0) {
            this.level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, v.x, v.y, v.z, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? 0.0625 : r.nextDouble() * (double)0.0125f;
        Vec3 v2 = c.add(VecHelper.offsetRandomly(Vec3.ZERO, r, 0.5f).multiply(1.0, 0.25, 1.0).normalize().scale((empty ? 0.25 : 0.5) + r.nextDouble() * 0.125)).add(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, v2.x, v2.y, v2.z, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, v2.x, v2.y, v2.z, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        RandomSource r = this.level.random;
        for (int i = 0; i < 20; ++i) {
            Vec3 offset = VecHelper.offsetRandomly(Vec3.ZERO, r, 0.5f).multiply(1.0, 0.25, 1.0).normalize();
            Vec3 v = c.add(offset.scale(0.5 + r.nextDouble() * 0.125)).add(0.0, 0.125, 0.0);
            Vec3 m = offset.scale(0.03125);
            this.level.addParticle((ParticleOptions)(soulFlame ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME), v.x, v.y, v.z, m.x, m.y, m.z);
        }
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

