/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.NumericSingleLineDisplaySource;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class KineticSpeedDisplaySource
extends NumericSingleLineDisplaySource {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        float speed;
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof SpeedGaugeBlockEntity)) {
            return ZERO.copy();
        }
        SpeedGaugeBlockEntity speedGauge = (SpeedGaugeBlockEntity)blockEntity;
        boolean absoluteValue = context.sourceConfig().getIntOr("Directional", 0) == 0;
        float f = speed = absoluteValue ? Math.abs(speedGauge.getSpeed()) : speedGauge.getSpeed();
        if (Mth.equal((float)speed, (float)0.0f)) {
            speed = 0.0f;
        }
        return Component.literal((String)this.format.format(speed).replace("\u00a0", " ")).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"create.generic.unit.rpm"));
    }

    @Override
    protected String getTranslationKey() {
        return "kinetic_speed";
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

