/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class KineticStressDisplaySource
extends PercentOrProgressBarDisplaySource {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

    @Override
    protected MutableComponent formatNumeric(DisplayLinkContext context, Float currentLevel) {
        int mode = this.getMode(context);
        if (mode == 1) {
            return super.formatNumeric(context, currentLevel);
        }
        if (Mth.equal((float)currentLevel.floatValue(), (float)0.0f)) {
            currentLevel = Float.valueOf(0.0f);
        }
        MutableComponent text = Component.literal((String)this.format.format(currentLevel).replace("\u00a0", " "));
        if (context.getTargetBlockEntity() instanceof FlapDisplayBlockEntity) {
            text.append((Component)Component.literal((String)" "));
        }
        return text.append((Component)Component.translatable((String)"create.generic.unit.stress"));
    }

    private int getMode(DisplayLinkContext context) {
        return context.sourceConfig().getIntOr("Mode", 0);
    }

    @Override
    protected Float getProgress(DisplayLinkContext context) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof StressGaugeBlockEntity)) {
            return null;
        }
        StressGaugeBlockEntity stressGauge = (StressGaugeBlockEntity)blockEntity;
        float capacity = stressGauge.getNetworkCapacity();
        float stress = stressGauge.getNetworkStress();
        if (capacity == 0.0f) {
            return Float.valueOf(0.0f);
        }
        return switch (this.getMode(context)) {
            case 0, 1 -> Float.valueOf(stress / capacity);
            case 2 -> Float.valueOf(stress);
            case 3 -> Float.valueOf(capacity);
            case 4 -> Float.valueOf(capacity - stress);
            default -> Float.valueOf(0.0f);
        };
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    @Override
    protected boolean progressBarActive(DisplayLinkContext context) {
        return this.getMode(context) == 0;
    }

    @Override
    protected String getTranslationKey() {
        return "kinetic_stress";
    }
}

