/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.nixieTube;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class NixieTubeBlockEntity
extends SmartBlockEntity {
    private int redstoneStrength = 0;
    private Optional<Component> customText = Optional.empty();
    private int nixieIndex;
    private Couple<String> displayedStrings;
    private boolean keepAlive;
    private WeakReference<SignalBlockEntity> cachedSignalTE = new WeakReference<Object>(null);
    public SignalBlockEntity.SignalState signalState;

    public NixieTubeBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.NIXIE_TUBE, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            return;
        }
        this.signalState = null;
        SignalBlockEntity signalBlockEntity = (SignalBlockEntity)this.cachedSignalTE.get();
        if (signalBlockEntity == null || signalBlockEntity.isRemoved()) {
            Direction facing = NixieTubeBlock.getFacing(this.getBlockState());
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(facing.getOpposite()));
            if (blockEntity instanceof SignalBlockEntity) {
                SignalBlockEntity signal = (SignalBlockEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signal);
            }
            return;
        }
        this.signalState = signalBlockEntity.getState();
    }

    @Override
    public void initialize() {
        if (this.level.isClientSide()) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        return this.customText.isEmpty();
    }

    @Nullable
    public Couple<String> getDisplayedStrings() {
        return this.displayedStrings;
    }

    public MutableComponent getFullText() {
        return this.customText.map(Component::copy).orElse(Component.literal((String)("" + this.redstoneStrength)));
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.level, this.worldPosition);
        this.notifyUpdate();
    }

    public void displayCustomText(Component text, int nixiePositionInRow) {
        if (text == null) {
            return;
        }
        if (this.customText.filter(d -> d.equals((Object)text)).isPresent()) {
            return;
        }
        this.customText = Optional.ofNullable(DynamicComponent.parseCustomText(this.level, this.worldPosition, text));
        this.nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.level, this.worldPosition);
        this.notifyUpdate();
    }

    public void displayEmptyText(int nixiePositionInRow) {
        this.displayCustomText(CommonComponents.EMPTY, nixiePositionInRow);
    }

    public void updateDisplayedStrings() {
        if (this.signalState != null) {
            return;
        }
        this.customText.map(Component::getString).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create(this.charOrEmpty((String)fullText, this.nixieIndex * 2), this.charOrEmpty((String)fullText, this.nixieIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create(this.redstoneStrength < 10 ? "0" : "1", String.valueOf(this.redstoneStrength % 10));
        });
    }

    public void clearCustomText() {
        this.nixieIndex = 0;
        this.customText = Optional.empty();
    }

    public int getRedstoneStrength() {
        return this.redstoneStrength;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        view.read("CustomText", ComponentSerialization.CODEC).ifPresentOrElse(text -> {
            this.customText = Optional.of(text);
            this.nixieIndex = view.getIntOr("CustomTextIndex", 0);
        }, () -> {
            this.redstoneStrength = view.getIntOr("RedstoneStrength", 0);
        });
        if (clientPacket || this.isVirtual()) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.customText.ifPresentOrElse(text -> {
            view.putInt("CustomTextIndex", this.nixieIndex);
            view.store("CustomText", ComponentSerialization.CODEC, text);
        }, () -> view.putInt("RedstoneStrength", this.redstoneStrength));
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        BlockState state = this.level.getBlockState(pos);
        if (this.getType().isValid(state)) {
            this.keepAlive = true;
            this.setBlockState(state);
        } else {
            super.preRemoveSideEffects(pos, oldState);
        }
    }

    @Override
    public void setRemoved() {
        if (this.keepAlive) {
            this.keepAlive = false;
            this.level.getChunk(this.worldPosition).setBlockEntity((BlockEntity)this);
        } else {
            super.setRemoved();
        }
    }
}

