/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics.cannon;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SchematicannonInventory
implements ItemInventory {
    private final SchematicannonBlockEntity blockEntity;
    private final NonNullList<ItemStack> stacks;

    public SchematicannonInventory(SchematicannonBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.stacks = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return switch (slot) {
            case 0 -> stack.is((Item)AllItems.SCHEMATIC);
            case 1 -> false;
            case 2 -> {
                if (stack.is((Item)AllItems.CLIPBOARD) || stack.is(Items.BOOK) || stack.is(Items.WRITTEN_BOOK)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> false;
            case 4 -> stack.is(Items.GUNPOWDER);
            default -> true;
        };
    }

    public int getContainerSize() {
        return 5;
    }

    public ItemStack getItem(int slot) {
        if (slot >= 5) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 5) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
    }

    @Override
    public void setChanged() {
        this.blockEntity.setChanged();
    }

    public void read(ValueInput view) {
        view.read("Inventory", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(list -> {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                this.stacks.set(i, (Object)((ItemStack)list.get(i)));
            }
        }, () -> this.stacks.clear());
    }

    public void write(ValueOutput view) {
        view.store("Inventory", CreateCodecs.ITEM_LIST_CODEC, this.stacks);
    }
}

