/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.google.common.base.Strings;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageSyncData;
import com.zurrtum.create.content.trains.entity.Navigation;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionBlockChangedPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainHUDControlUpdatePacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainPromptPacket;
import com.zurrtum.create.infrastructure.particle.CubeParticleData;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class CarriageContraptionEntity
extends OrientedContraptionEntity {
    private static final EntityDataAccessor<CarriageSyncData> CARRIAGE_DATA = SynchedEntityData.defineId(CarriageContraptionEntity.class, AllSynchedDatas.CARRIAGE_DATA_HANDLER);
    private static final EntityDataAccessor<Optional<UUID>> TRACK_GRAPH = SynchedEntityData.defineId(CarriageContraptionEntity.class, AllSynchedDatas.OPTIONAL_UUID_HANDLER);
    private static final EntityDataAccessor<Boolean> SCHEDULED = SynchedEntityData.defineId(CarriageContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final Map<BehaviourType<?>, EntityBehaviour<?>> behaviours = new Reference2ObjectArrayMap();
    public UUID trainId;
    public int carriageIndex;
    private Carriage carriage;
    public boolean validForRender = false;
    public boolean movingBackwards;
    public boolean leftTickingChunks;
    public boolean firstPositionUpdate = true;
    private boolean arrivalSoundPlaying;
    private boolean arrivalSoundReversed;
    private int arrivalSoundTicks;
    private Vec3 serverPrevPos;
    Vec3 derailParticleOffset;
    public Set<BlockPos> particleSlice = new HashSet<BlockPos>();
    public float particleAvgY = 0.0f;
    double navDistanceTotal = 0.0;
    int hudPacketCooldown = 0;
    boolean stationMessage = false;

    public CarriageContraptionEntity(EntityType<? extends CarriageContraptionEntity> type, Level world) {
        super((EntityType<? extends OrientedContraptionEntity>)type, world);
        this.arrivalSoundTicks = Integer.MIN_VALUE;
        this.derailParticleOffset = VecHelper.offsetRandomly(Vec3.ZERO, world.random, 1.5f).multiply(1.0, 0.25, 1.0);
        ArrayList list = new ArrayList();
        AllClientHandle.INSTANCE.addBehaviours(this, list);
        list.forEach((Consumer<EntityBehaviour<?>>)((Consumer<EntityBehaviour>)b -> this.behaviours.put(b.getType(), (EntityBehaviour<?>)b)));
    }

    public <T extends EntityBehaviour<?>> T getBehaviour(BehaviourType<T> type) {
        return (T)this.behaviours.get(type);
    }

    public boolean isLocalInstanceAuthoritative() {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CARRIAGE_DATA, (Object)new CarriageSyncData());
        builder.define(TRACK_GRAPH, Optional.empty());
        builder.define(SCHEDULED, (Object)false);
    }

    public void syncCarriage() {
        CarriageSyncData carriageData = this.getCarriageData();
        if (carriageData == null) {
            return;
        }
        if (this.carriage == null) {
            return;
        }
        carriageData.update(this, this.carriage);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (!this.level().isClientSide()) {
            return;
        }
        this.bindCarriage();
        if (TRACK_GRAPH.equals(key)) {
            this.updateTrackGraph();
        }
        if (CARRIAGE_DATA.equals(key)) {
            CarriageSyncData carriageData = this.getCarriageData();
            if (carriageData == null) {
                return;
            }
            if (this.carriage == null) {
                return;
            }
            carriageData.apply(this, this.carriage);
        }
    }

    public CarriageSyncData getCarriageData() {
        return (CarriageSyncData)this.entityData.get(CARRIAGE_DATA);
    }

    public boolean hasSchedule() {
        return (Boolean)this.entityData.get(SCHEDULED);
    }

    public void setServerSidePrevPosition() {
        this.serverPrevPos = this.position();
    }

    @Override
    public Vec3 getPrevPositionVec() {
        if (!this.level().isClientSide() && this.serverPrevPos != null) {
            return this.serverPrevPos;
        }
        return super.getPrevPositionVec();
    }

    public boolean isLocalCoordWithin(BlockPos localPos, int min, int max) {
        Contraption contraption = this.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        Direction facing = cc.getAssemblyDirection();
        Direction.Axis axis = facing.getClockWise().getAxis();
        int coord = axis.choose(localPos.getZ(), localPos.getY(), localPos.getX()) * -facing.getAxisDirection().getStep();
        return coord >= min && coord <= max;
    }

    public static CarriageContraptionEntity create(Level world, CarriageContraption contraption) {
        CarriageContraptionEntity entity = new CarriageContraptionEntity((EntityType<? extends CarriageContraptionEntity>)AllEntityTypes.CARRIAGE_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(contraption.getAssemblyDirection().getClockWise());
        entity.startAtInitialYaw();
        return entity;
    }

    @Override
    public void tick() {
        super.tick();
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            for (Entity entity : this.getPassengers()) {
                BlockPos seatOf;
                if (entity instanceof Player || (seatOf = cc.getSeatOf(entity.getUUID())) == null || cc.conductorSeats.get(seatOf) == null) continue;
                this.alignPassenger(entity);
            }
        }
        this.behaviours.values().forEach(EntityBehaviour::tick);
    }

    @Override
    public void setBlock(BlockPos localPos, StructureTemplate.StructureBlockInfo newInfo) {
        if (this.carriage == null) {
            return;
        }
        this.carriage.forEachPresentEntity(cce -> {
            cce.contraption.getBlocks().put(localPos, newInfo);
            ((ServerLevel)cce.level()).getChunkSource().sendToTrackingPlayers((Entity)cce, (Packet)new ContraptionBlockChangedPacket(cce.getId(), localPos, newInfo.state()));
        });
    }

    @Override
    protected void tickContraption() {
        boolean isStalled;
        Contraption contraption;
        if (this.nonDamageTicks > 0) {
            --this.nonDamageTicks;
        }
        if (!((contraption = this.contraption) instanceof CarriageContraption)) {
            return;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        if (this.carriage == null) {
            if (this.level().isClientSide()) {
                this.bindCarriage();
            } else {
                this.discard();
            }
            return;
        }
        if (!Create.RAILWAYS.sided((LevelAccessor)this.level()).trains.containsKey(this.carriage.train.id)) {
            this.discard();
            return;
        }
        this.tickActors();
        this.carriage.stalled = isStalled = this.isStalled();
        CarriageSyncData carriageData = this.getCarriageData();
        if (!this.level().isClientSide()) {
            this.entityData.set(SCHEDULED, (Object)(this.carriage.train.runtime.getSchedule() != null ? 1 : 0));
            boolean shouldCarriageSyncThisTick = this.carriage.train.shouldCarriageSyncThisTick(this.level().getGameTime(), this.getType().updateInterval());
            if (shouldCarriageSyncThisTick && carriageData.isDirty()) {
                this.entityData.set(CARRIAGE_DATA, (Object)carriageData, true);
                carriageData.setDirty(false);
            }
            Navigation navigation = this.carriage.train.navigation;
            if (navigation.announceArrival && Math.abs(navigation.distanceToDestination) < 60.0 && this.carriageIndex == (this.carriage.train.speed < 0.0 ? this.carriage.train.carriages.size() - 1 : 0)) {
                navigation.announceArrival = false;
                this.arrivalSoundPlaying = true;
                this.arrivalSoundReversed = this.carriage.train.speed < 0.0;
                this.arrivalSoundTicks = Integer.MIN_VALUE;
            }
            if (this.arrivalSoundPlaying) {
                this.tickArrivalSound(cc);
            }
            this.entityData.set(TRACK_GRAPH, Optional.ofNullable(this.carriage.train.graph).map(g -> g.id));
            this.level().gameEvent((Entity)this, (Holder)GameEvent.RESONATE_8, this.position());
            return;
        }
        Carriage.DimensionalCarriageEntity dce = this.carriage.getDimensional(this.level());
        if (this.tickCount % 10 == 0) {
            this.updateTrackGraph();
        }
        if (!dce.pointsInitialised) {
            return;
        }
        carriageData.approach(this, this.carriage, 1.0f / (float)this.getType().updateInterval());
        if (!this.carriage.train.derailed) {
            this.carriage.updateContraptionAnchors();
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        dce.alignEntity(this);
        double distanceTo = 0.0;
        if (!this.firstPositionUpdate) {
            Vec3 diff = this.position().subtract(this.xo, this.yo, this.zo);
            Vec3 relativeDiff = VecHelper.rotate(diff, this.yaw, Direction.Axis.Y);
            double signum = Math.signum(-relativeDiff.x);
            distanceTo = diff.length() * signum;
            this.movingBackwards = signum < 0.0;
        }
        ((CarriageBogey)this.carriage.bogeys.getFirst()).updateAngles(this, distanceTo);
        if (this.carriage.isOnTwoBogeys()) {
            ((CarriageBogey)this.carriage.bogeys.getSecond()).updateAngles(this, distanceTo);
        }
        if (this.carriage.train.derailed) {
            this.spawnDerailParticles(this.carriage);
        }
        if (dce.pivot != null) {
            this.spawnPortalParticles(dce);
        }
        this.firstPositionUpdate = false;
        this.validForRender = true;
    }

    private void bindCarriage() {
        if (this.carriage != null) {
            return;
        }
        Train train = Create.RAILWAYS.sided((LevelAccessor)this.level()).trains.get(this.trainId);
        if (train == null || train.carriages.size() <= this.carriageIndex) {
            return;
        }
        this.carriage = train.carriages.get(this.carriageIndex);
        if (this.carriage != null) {
            Carriage.DimensionalCarriageEntity dimensional = this.carriage.getDimensional(this.level());
            dimensional.entity = new WeakReference<CarriageContraptionEntity>(this);
            dimensional.pivot = null;
            this.carriage.updateContraptionAnchors();
            dimensional.updateRenderedCutoff();
        }
        this.updateTrackGraph();
    }

    private void tickArrivalSound(CarriageContraption cc) {
        List<Carriage> carriages = this.carriage.train.carriages;
        if (this.arrivalSoundTicks == Integer.MIN_VALUE) {
            int carriageCount = carriages.size();
            Integer tick = null;
            for (int index = 0; index < carriageCount; ++index) {
                Contraption contraption;
                int i = this.arrivalSoundReversed ? carriageCount - 1 - index : index;
                Carriage carriage = carriages.get(i);
                CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)carriage.getDimensional((Level)this.level()).entity.get());
                if (entity == null || !((contraption = entity.contraption) instanceof CarriageContraption)) break;
                CarriageContraption otherCC = (CarriageContraption)contraption;
                Integer n = tick = this.arrivalSoundReversed ? otherCC.soundQueue.lastTick() : otherCC.soundQueue.firstTick();
                if (tick != null) break;
            }
            if (tick == null) {
                this.arrivalSoundPlaying = false;
                return;
            }
            this.arrivalSoundTicks = tick;
        }
        if (this.tickCount % 2 == 0) {
            return;
        }
        boolean keepTicking = false;
        for (Carriage c : carriages) {
            Contraption contraption;
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)c.getDimensional((Level)this.level()).entity.get());
            if (entity == null || !((contraption = entity.contraption) instanceof CarriageContraption)) continue;
            CarriageContraption otherCC = (CarriageContraption)contraption;
            keepTicking |= otherCC.soundQueue.tick(entity, this.arrivalSoundTicks, this.arrivalSoundReversed);
        }
        if (!keepTicking) {
            this.arrivalSoundPlaying = false;
            return;
        }
        this.arrivalSoundTicks += this.arrivalSoundReversed ? -1 : 1;
    }

    @Override
    public void tickActors() {
        super.tickActors();
    }

    @Override
    protected boolean isActorActive(MovementContext context, MovementBehaviour actor) {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        if (!super.isActorActive(context, actor)) {
            return false;
        }
        return cc.notInPortal() || this.level().isClientSide();
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
    }

    private void spawnDerailParticles(Carriage carriage) {
        if (this.random.nextFloat() < 0.05f) {
            Vec3 v = this.position().add(this.derailParticleOffset);
            this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, v.x, v.y, v.z, 0.0, 0.04, 0.0);
        }
    }

    protected void addPassenger(Entity pPassenger) {
        super.addPassenger(pPassenger);
        if (!(pPassenger instanceof Player)) {
            return;
        }
        Player player = (Player)pPassenger;
        AllSynchedDatas.CONTRAPTION_MOUNT_LOCATION.set((Entity)player, Optional.ofNullable(player.position()));
    }

    private void spawnPortalParticles(Carriage.DimensionalCarriageEntity dce) {
        Vec3 pivot = dce.pivot.getLocation().add(0.0, 1.5, 0.0);
        if (this.particleSlice.isEmpty()) {
            return;
        }
        boolean alongX = Mth.equal((double)pivot.x, (double)Math.round(pivot.x));
        int extraFlip = Direction.fromYRot((double)this.yaw).getAxisDirection().getStep();
        Vec3 emitter = pivot.add(0.0, (double)this.particleAvgY, 0.0);
        double speed = this.position().distanceTo(this.getPrevPositionVec());
        int size = (int)((double)this.particleSlice.size() * Mth.clamp((double)(4.0 - speed * 4.0), (double)0.0, (double)4.0));
        for (BlockPos pos : this.particleSlice) {
            if (size != 0 && this.random.nextInt(size) != 0) continue;
            if (alongX) {
                pos = new BlockPos(0, pos.getY(), pos.getX());
            }
            Vec3 v = pivot.add((double)(pos.getX() * extraFlip), (double)pos.getY(), (double)(pos.getZ() * extraFlip));
            CubeParticleData data = new CubeParticleData(0.25f, 0.0f, 0.5f, 0.65f + (this.random.nextFloat() - 0.5f) * 0.25f, 4, false);
            Vec3 m = v.subtract(emitter).normalize().scale((double)0.325f);
            m = VecHelper.rotate(m, this.random.nextFloat() * 360.0f, alongX ? Direction.Axis.X : Direction.Axis.Z);
            m = m.add(VecHelper.offsetRandomly(Vec3.ZERO, this.random, 0.25f));
            this.level().addParticle((ParticleOptions)data, v.x, v.y, v.z, m.x, m.y, m.z);
        }
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        this.entityData.set(CARRIAGE_DATA, (Object)new CarriageSyncData());
        if (this.carriage != null) {
            Carriage.DimensionalCarriageEntity dce = this.carriage.getDimensional(this.level());
            dce.pointsInitialised = false;
            this.carriage.leadingBogey().couplingAnchors = Couple.create(null, null);
            this.carriage.trailingBogey().couplingAnchors = Couple.create(null, null);
        }
        this.firstPositionUpdate = true;
        this.behaviours.values().forEach(EntityBehaviour::destroy);
    }

    @Override
    protected void writeAdditional(ValueOutput view, boolean spawnPacket) {
        super.writeAdditional(view, spawnPacket);
        view.store("TrainId", UUIDUtil.CODEC, (Object)this.trainId);
        view.putInt("CarriageIndex", this.carriageIndex);
    }

    @Override
    protected void readAdditional(ValueInput view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);
        this.trainId = (UUID)view.read("TrainId", UUIDUtil.CODEC).orElseThrow();
        this.carriageIndex = view.getIntOr("CarriageIndex", 0);
        if (spawnPacket) {
            this.xOld = this.getX();
            this.yOld = this.getY();
            this.zOld = this.getZ();
        }
    }

    @Override
    public Component getContraptionName() {
        if (this.carriage != null) {
            return this.carriage.train.name;
        }
        return super.getContraptionName();
    }

    public Couple<Boolean> checkConductors() {
        Couple<Boolean> sides = Couple.create(false, false);
        Contraption contraption = this.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return sides;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        sides.setFirst((Boolean)cc.blockConductors.getFirst());
        sides.setSecond((Boolean)cc.blockConductors.getSecond());
        for (Entity entity : this.getPassengers()) {
            Couple<Boolean> validSides;
            BlockPos seatOf;
            if (entity instanceof Player || (seatOf = cc.getSeatOf(entity.getUUID())) == null || (validSides = cc.conductorSeats.get(seatOf)) == null) continue;
            sides.setFirst((Boolean)sides.getFirst() != false || (Boolean)validSides.getFirst() != false);
            sides.setSecond((Boolean)sides.getSecond() != false || (Boolean)validSides.getSecond() != false);
        }
        return sides;
    }

    @Override
    public boolean startControlling(BlockPos controlsLocalPos, Player player) {
        if (player == null || player.isSpectator()) {
            return false;
        }
        if (this.carriage == null) {
            return false;
        }
        if (this.carriage.train.derailed) {
            return false;
        }
        Train train = this.carriage.train;
        if (train.runtime.getSchedule() != null && !train.runtime.paused) {
            train.status.manualControls();
        }
        train.navigation.cancelNavigation();
        train.runtime.paused = true;
        train.navigation.waitingForSignal = null;
        return true;
    }

    public Component getDisplayName() {
        if (this.carriage == null) {
            return Component.nullToEmpty((String)"create.train");
        }
        return this.carriage.train.name;
    }

    @Override
    public boolean control(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        boolean counteringAcceleration;
        if (this.carriage == null) {
            return false;
        }
        if (this.carriage.train.derailed) {
            return false;
        }
        if (this.level().isClientSide()) {
            return true;
        }
        if (player.isSpectator()) {
            return false;
        }
        if (!this.toGlobalVector(VecHelper.getCenterOf((Vec3i)controlsLocalPos), 1.0f).closerThan((Position)player.position(), 8.0)) {
            return false;
        }
        if (heldControls.contains(5)) {
            return false;
        }
        StructureTemplate.StructureBlockInfo info = this.contraption.getBlocks().get(controlsLocalPos);
        Direction initialOrientation = this.getInitialOrientation().getCounterClockWise();
        boolean inverted = false;
        if (info != null && info.state().hasProperty((Property)ControlsBlock.FACING)) {
            boolean bl = inverted = !((Direction)info.state().getValue((Property)ControlsBlock.FACING)).equals((Object)initialOrientation);
        }
        if (this.hudPacketCooldown-- <= 0 && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.connection.send((Packet)new TrainHUDControlUpdatePacket(this.carriage.train));
            this.hudPacketCooldown = 5;
        }
        int targetSpeed = 0;
        if (heldControls.contains(0)) {
            ++targetSpeed;
        }
        if (heldControls.contains(1)) {
            --targetSpeed;
        }
        int targetSteer = 0;
        if (heldControls.contains(2)) {
            ++targetSteer;
        }
        if (heldControls.contains(3)) {
            --targetSteer;
        }
        if (inverted) {
            targetSpeed *= -1;
            targetSteer *= -1;
        }
        if (targetSpeed != 0) {
            this.carriage.train.burnFuel(this.level());
        }
        boolean slow = inverted ^ targetSpeed < 0;
        boolean spaceDown = heldControls.contains(4);
        GlobalStation currentStation = this.carriage.train.getCurrentStation();
        if (currentStation != null && spaceDown) {
            this.sendPrompt(player, Component.translatable((String)"create.train.arrived_at", (Object[])new Object[]{Component.literal((String)currentStation.name).withColor(7358000)}), false);
            return true;
        }
        if (this.carriage.train.speedBeforeStall != null && targetSpeed != 0 && Math.signum(this.carriage.train.speedBeforeStall) != (double)Math.signum(targetSpeed)) {
            this.carriage.train.cancelStall();
        }
        if (currentStation != null && targetSpeed != 0) {
            this.stationMessage = false;
            this.sendPrompt(player, Component.translatable((String)"create.train.departing_from", (Object[])new Object[]{Component.literal((String)currentStation.name).withColor(7358000)}), false);
        }
        if (currentStation == null) {
            double directedSpeed;
            Navigation nav = this.carriage.train.navigation;
            if (nav.destination != null) {
                if (!spaceDown) {
                    nav.cancelNavigation();
                }
                if (spaceDown) {
                    double f = nav.distanceToDestination / this.navDistanceTotal;
                    int progress = (int)(Mth.clamp((double)(1.0 - (1.0 - f) * (1.0 - f)), (double)0.0, (double)1.0) * 30.0);
                    boolean arrived = progress == 0;
                    MutableComponent whiteComponent = Component.literal((String)Strings.repeat((String)"|", (int)progress));
                    MutableComponent greenComponent = Component.literal((String)Strings.repeat((String)"|", (int)(30 - progress)));
                    int fromColor = 16761412;
                    int toColor = 5413141;
                    int mixedColor = Color.mixColors(toColor, fromColor, (float)progress / 30.0f);
                    int targetColor = arrived ? toColor : 0x544D45;
                    MutableComponent component = greenComponent.withColor(mixedColor).append((Component)whiteComponent.withColor(targetColor));
                    this.sendPrompt(player, component, true);
                    this.carriage.train.manualTick = true;
                    return true;
                }
            }
            double d = directedSpeed = targetSpeed != 0 ? (double)targetSpeed : this.carriage.train.speed;
            GlobalStation lookAhead = nav.findNearestApproachable(!this.carriage.train.doubleEnded || (directedSpeed != 0.0 ? directedSpeed > 0.0 : !inverted));
            if (lookAhead != null) {
                if (spaceDown) {
                    this.carriage.train.manualTick = true;
                    nav.startNavigation(nav.findPathTo(lookAhead, -1.0));
                    this.carriage.train.manualTick = false;
                    this.navDistanceTotal = nav.distanceToDestination;
                    return true;
                }
                this.displayApproachStationMessage(player, lookAhead);
            } else {
                this.cleanUpApproachStationMessage(player);
            }
        }
        this.carriage.train.manualSteer = targetSteer < 0 ? TravellingPoint.SteerDirection.RIGHT : (targetSteer > 0 ? TravellingPoint.SteerDirection.LEFT : TravellingPoint.SteerDirection.NONE);
        double topSpeed = this.carriage.train.maxSpeed() * AllConfigs.server().trains.manualTrainSpeedModifier.getF();
        double cappedTopSpeed = topSpeed * this.carriage.train.throttle;
        if (this.carriage.getLeadingPoint().edge != null && this.carriage.getLeadingPoint().edge.isTurn() || this.carriage.getTrailingPoint().edge != null && this.carriage.getTrailingPoint().edge.isTurn()) {
            topSpeed = this.carriage.train.maxTurnSpeed();
        }
        if (slow) {
            topSpeed /= 4.0;
        }
        this.carriage.train.targetSpeed = Math.min(topSpeed, cappedTopSpeed) * (double)targetSpeed;
        boolean bl = counteringAcceleration = Math.abs((double)Math.signum(targetSpeed) - Math.signum(this.carriage.train.speed)) > 1.5;
        if (slow && !counteringAcceleration) {
            this.carriage.train.backwardsDriver = player;
        }
        this.carriage.train.manualTick = true;
        this.carriage.train.approachTargetSpeed(counteringAcceleration ? 2.0f : 1.0f);
        return true;
    }

    private void sendPrompt(Player player, MutableComponent component, boolean shadow) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.connection.send((Packet)new TrainPromptPacket((Component)component, shadow));
        }
    }

    private void displayApproachStationMessage(Player player, GlobalStation station) {
        this.sendPrompt(player, Component.translatable((String)"create.contraption.controls.approach_station", (Object[])new Object[]{Component.keybind((String)"key.jump"), station.name}), false);
        this.stationMessage = true;
    }

    private void cleanUpApproachStationMessage(Player player) {
        if (!this.stationMessage) {
            return;
        }
        player.displayClientMessage(CommonComponents.EMPTY, true);
        this.stationMessage = false;
    }

    private void updateTrackGraph() {
        if (this.carriage == null) {
            return;
        }
        Optional optional = (Optional)this.entityData.get(TRACK_GRAPH);
        if (optional.isEmpty()) {
            this.carriage.train.graph = null;
            this.carriage.train.derailed = true;
            return;
        }
        TrackGraph graph = Create.RAILWAYS.sided((LevelAccessor)this.level()).trackNetworks.get(optional.get());
        if (graph == null) {
            return;
        }
        this.carriage.train.graph = graph;
        this.carriage.train.derailed = false;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public Carriage getCarriage() {
        return this.carriage;
    }

    public void setCarriage(Carriage carriage) {
        this.carriage = carriage;
        this.trainId = carriage.train.id;
        this.carriageIndex = carriage.train.carriages.indexOf(carriage);
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            cc.swapStorageAfterAssembly(this);
        }
        if (carriage.train.graph != null) {
            this.entityData.set(TRACK_GRAPH, Optional.of(carriage.train.graph.id));
        }
        Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensional(this.level());
        dimensional.pivot = null;
        carriage.updateContraptionAnchors();
        dimensional.updateRenderedCutoff();
    }

    public void updateRenderedPortalCutoff() {
        if (this.carriage == null) {
            return;
        }
        this.particleSlice.clear();
        this.particleAvgY = 0.0f;
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            Direction forward = cc.getAssemblyDirection().getClockWise();
            Direction.Axis axis = forward.getAxis();
            boolean x = axis == Direction.Axis.X;
            boolean flip = true;
            for (BlockPos pos : this.contraption.getBlocks().keySet()) {
                if (!cc.atSeam(pos)) continue;
                int pX = x ? pos.getX() : pos.getZ();
                pos = new BlockPos(pX *= forward.getAxisDirection().getStep() * (flip ? 1 : -1), pos.getY(), 0);
                this.particleSlice.add(pos);
                this.particleAvgY += (float)pos.getY();
            }
        }
        if (this.particleSlice.size() > 0) {
            this.particleAvgY /= (float)this.particleSlice.size();
        }
    }
}

