/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.mojang.serialization.Codec;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class RedstoneLinkCondition
extends ScheduleWaitCondition {
    private static final Codec<Couple<RedstoneLinkNetworkHandler.Frequency>> FREQUENCY_CODEC = Couple.codec(RedstoneLinkNetworkHandler.Frequency.CODEC);
    public Couple<RedstoneLinkNetworkHandler.Frequency> freq = Couple.create(() -> RedstoneLinkNetworkHandler.Frequency.EMPTY);

    public RedstoneLinkCondition(Identifier id) {
        super(id);
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        int lastChecked = context.contains("LastChecked") ? context.getIntOr("LastChecked", 0) : -1;
        int status = Create.REDSTONE_LINK_NETWORK_HANDLER.globalPowerVersion.get();
        if (status == lastChecked) {
            return false;
        }
        context.putInt("LastChecked", status);
        return Create.REDSTONE_LINK_NETWORK_HANDLER.hasAnyLoadedPower(this.freq) != this.lowActivation();
    }

    @Override
    protected void writeAdditional(ValueOutput view) {
        view.store("Frequency", FREQUENCY_CODEC, this.freq);
    }

    public boolean lowActivation() {
        return this.intData("Inverted") == 1;
    }

    @Override
    protected void readAdditional(ValueInput view) {
        view.read("Frequency", FREQUENCY_CODEC).ifPresent(freq -> {
            this.freq = freq;
        });
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        return Component.translatable((String)"create.schedule.condition.redstone_link.status");
    }
}

