/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.codec;

import io.netty.buffer.ByteBuf;
import java.util.Vector;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface CreateStreamCodecs {
    public static final StreamCodec<FriendlyByteBuf, byte[]> UNBOUNDED_BYTE_ARRAY = new StreamCodec<FriendlyByteBuf, byte[]>(){

        public byte[] decode(FriendlyByteBuf buf) {
            return buf.readByteArray();
        }

        public void encode(FriendlyByteBuf buf, byte[] data) {
            buf.writeByteArray(data);
        }
    };

    @Deprecated(forRemoval=true)
    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, Vector<V>> vector() {
        return codec -> ByteBufCodecs.collection(Vector::new, (StreamCodec)codec);
    }

    public static <C> StreamCodec<RegistryFriendlyByteBuf, C> ofLegacyNbtWithRegistries(final BiFunction<C, HolderLookup.Provider, CompoundTag> writer, final BiFunction<HolderLookup.Provider, CompoundTag, C> reader) {
        return new StreamCodec<RegistryFriendlyByteBuf, C>(){

            public C decode(RegistryFriendlyByteBuf buffer) {
                return reader.apply(buffer.registryAccess(), buffer.readNbt());
            }

            public void encode(RegistryFriendlyByteBuf buffer, C value) {
                buffer.writeNbt((Tag)writer.apply(value, buffer.registryAccess()));
            }
        };
    }
}

